# Maywood Cycles Due Diligence (DD) Report

**Prepared by:** Surrey Machinist Co. Ltd

---

## Key Issues (1/2)

> **Note:** Current Year ("CY") is the year of the DD report pre acquisition

### Financing

- Management have assumed that the NatWest mortgage loan (£4.8m) will be retained on existing terms. NatWest has the right to require repayment on demand following a change of ownership and therefore this mortgage loan may require refinancing as there is insufficient alternative working capital capacity available to cover it at the moment.
- Management now believe that the full balance of the directors' loans (£1m) will be repaid from existing working capital on acquisition. This causes the facility limits to be breached by early CY+1 and therefore additional finance will need to be sought to fund such a repayment. Whilst the breach only exists for one month, borrowings are close to the limits for the first six months of CY+1 indicating that additional funds may be required if performance is below expectations.

### Customer Dependence

- The UK constitutes 23% of the turnover.
- Agreements with each of these customers expire during the forecast period under review and the loss of any of these customers would have a significant impact on volumes, production capacity and profitability.

### Key Personnel

- We are aware that some of the key management are either shareholders of Maywood and particularly key customer contacts. We are not aware of their future plans or your plans to secure their services after the sale.

### Contract Terms

- An exclusivity contract with Evans effectively means work for them takes precedent over other work regardless of opportunity cost foregone.
- Management are not aware of any instances where profitable work has been turned away.
- A consequential loss clause for late delivery exists in the several contracts. Maywood previously held an exclusive contract with Sport 2000 but the timing profile and volumes of work proved inefficient for Maywood's production schedule. Maywood therefore renegotiated a new non-exclusive agreement in CY-1. In exchange, Sport 2000 insisted on a consequential loss clause in the event of late delivery. No claim has ever been made by Sport 2000 for late delivery. It should be noted that all long term sales agreements contain penalty clauses for late delivery of between 1% and 25% of sales value.

### Seasonality

- Bicycle sales are seasonal with the majority of sales occurring in the spring, late summer and early autumn. This impacts on working capital as bicycles are assembled and held in stock until required despatch date.

### Aluminium Prices

- Aluminium is the main frame material for the company's bicycle range and is subject to significant price variations. There was a steep fall in prices end of CY-5 as a result of the global financial crisis but prices rose and fell again to CY-9 levels. Going forward, prices are expected to raise again.

---

## Key Issues (2/2)

### Fixed Costs

- The business has a high level of fixed costs associated with it, especially in terms of employment and depreciation costs. It is therefore critical to profitability that volumes are maintained and production scheduling maximises production capacity and minimises overtime premiums.

### Margins

- The margins earned are generally higher on race/road/mountain bicycles than on city/children bicycles.

### Capital Expenditure

- Maywood have undertaken significant capital investment in the last three years resulting in a major reorganisation and changes to working practices. However, most of the expenditure has been in the form of hire purchase agreements, creating an expense rather than a depreciable capital investment.
- Management do not consider that any further significant capital expenditure is required in the next three years and consequently have forecast capital spend at only £0.5m per annum. The extent to which further capital expenditure is required needs to be reviewed by your management.
- Given the reduction in future capital spend, the depreciation charge would be expected to fall during the forecast period as older plant becomes fully depreciated, however, this is not seen with the depreciation charge increasing with inflation. Potentially, depreciation is overstated in the forecasts and profit before tax and operating ratios could be improved.

### Standard Costs

- Standard costs are not regularly reviewed. The majority of machine cost recovery rates have only been set within the last few years as new equipment has been installed. Inaccurate standards will distort value added measures within the management accounts. Your management will need to review these standards.

### Sustainability of Staff Costs

- Staff costs for CY-1 and year to date are at 17% and 18% of turnover respectively. This is within the optimum range of 15% to 20%. Maywood achieved the impressive ratios as a result of staff cost controls including wage freezes and control of overtime payments. Such measures may not be sustainable in the longer term.

### PAYE Payments

- PAYE payments were deferred during CY-2 and CY-1 due to the difficult trading position and cash management policies. The large deferrals have now been repaid but the ongoing monthly liability is settled in two instalments during the following month, one of which is outside normal Inland Revenue deadlines.

### Pensions Costs

- No employer staff pension contributions were paid in CY-1, with catch up payments to be made in CY, CY+1 and CY+2.

---

## Points to be Carried Forward

**The following matters have come to our attention and we recommend further investigation:**

- Given the reliance on key customers, your management may wish to meet with them to discuss the implication of the deal prior to the sale.
- Your management needs to review the current file server and IT system to ensure that the system is sufficiently reliable.
- Given the limited future capital expenditure and high levels of expenditure in the last few years the utilisation of the tax losses needs to be reviewed.
- We have not reviewed the pension schemes or any correspondence with OPRA, the regulatory body, in relation to compliance with pension regulations.
- We have not reviewed fixed assets but are aware that a full fixed asset register is not available. We would recommend that a full inventory be undertaken prior to purchase. Furthermore, we have not reviewed the current state of the fixed assets.
- Supplier agreements for key components need to be reviewed for different pricing schedules or possible onerous terms not forecast.
- There is little documentation to support the three year forecasts. In particular, there is no breakdown of sales by customer, profitability by division or detailed overheads. As yet, no monthly profit and loss accounts, cash flows and balance sheets have been produced. Without significant further information it is difficult to assess the accuracy of the forecasts and working capital requirements. Furthermore, it is unlikely that the current forecasts will be sufficient for any fund raising purposes.

---

## Financial Information - P&L

| Income Statements | CY-4 | CY-3 | CY-2 | CY-1 |
|---|---|---|---|---|
| **Total revenue net of VAT** | 54,190,576 | 52,026,895 | 50,287,253 | 49,707,771 |
| Cost of goods sold and distribution | 34,762,243 | 33,346,025 | 33,256,403 | 32,850,775 |
| **Gross margin** | 19,428,333 | 18,680,870 | 17,030,850 | 16,856,996 |
| **Operating costs before depreciation** | 16,371,665 | 14,031,019 | 14,634,406 | 14,490,086 |
| Personnel | 9,656,400 | 8,397,399 | 8,528,806 | 8,673,571 |
| Rent and leases | 1,644,000 | 1,548,000 | 1,778,000 | 1,453,515 |
| Non-personnel R&D | 444,000 | 508,000 | 512,000 | 515,000 |
| Marketing & PR | 2,297,472 | 1,667,600 | 2,228,000 | 2,235,000 |
| Legal | 30,804 | 32,500 | 37,000 | 42,000 |
| Travel | 918,989 | 333,520 | 445,600 | 447,000 |
| Other operating costs | 1,380,000 | 1,544,000 | 1,105,000 | 1,124,000 |
| **EBITDA** | 3,056,668 | 4,649,851 | 2,396,444 | 2,366,910 |
| Depreciation | 655,693 | 635,984 | 608,407 | 584,766 |
| **Operating profit** | 2,400,975 | 4,013,867 | 1,788,037 | 1,782,144 |
| **Financial income/costs** | | | | |
| Interest income | 0 | 5,853 | 10,628 | 17,125 |
| Interest expense | 1,516,418 | 2,082,642 | 1,261,884 | 1,261,884 |
| **Profit before tax** | 884,557 | 1,937,078 | 536,781 | 537,385 |
| Taxation | 299,406 | 581,124 | 161,034 | 161,215 |
| Dividend | 0 | 0 | 0 | 0 |
| **Retained Earnings (Net Profit)** | 585,151 | 1,355,954 | 375,747 | 376,170 |

### Key Observations:

- The revenue decline has decelerated to an almost flat position. Revenue decline was 4.0%, 3.3%, 1.2% respectively from CY-3 to CY-1. This shows a clear stabilising of sales, which are now primed for growth.
- Cost of goods sold and gross margins remained consistent with the revenue evolution and previous years. Included in cost of good sold are the frame fabrication costs incurred with Zhongshan Frames of Taiwan.
- Personnel costs remain the largest fixed cost of the business. Personnel numbers have remained constant at 210 since CY-2. The operations have adapted to the personnel reduction from 254 employees in CY-4. The business currently operates with 43 permanent administrative staff (paid monthly) and 167 weekly-paid production employees.
- Rent and leases largely comprise hire purchase agreements on equipment (see hp schedule). The sale and lease-back of the Maywood Warehouse building in CY-1 has added another £365k to annual rent and lease costs in CY.
- Other costs remain in line with previous years, with the exception of legal costs which increased by 160% with the pending sale of the company.
- EBITDA remained a healthy £2.4m and net profit remained somewhat constant at £376k in CY-1.

---

## Financial Information - Balance Sheet

| Balance Sheets | CY-4 | CY-3 | CY-2 | CY-1 |
|---|---|---|---|---|
| **Fixed Assets** | 24,396,378 | 24,245,393 | 24,008,986 | 19,051,220 |
| Land & buildings | 12,845,000 | 12,845,000 | 12,845,000 | 7,845,000 |
| Plant & machinery | 6,235,055 | 6,084,070 | 5,847,663 | 5,889,897 |
| Financial assets / Company Holdings | 5,316,323 | 5,316,323 | 5,316,323 | 5,316,323 |
| **Current Assets** | 24,827,997 | 22,870,740 | 23,317,939 | 22,928,315 |
| Inventory | 5,636,350 | 6,947,089 | 6,928,417 | 6,935,164 |
| Accounts receivables | 18,063,525 | 14,434,075 | 15,209,578 | 15,214,816 |
| Other current assets | 432,122 | 449,963 | 445,066 | 417,250 |
| Prepayments | 696,000 | 685,333 | 164,043 | 186,027 |
| Cash or near-cash assets | 0 | 354,280 | 570,835 | 175,058 |
| **TOTAL ASSETS** | 49,224,375 | 47,116,133 | 47,326,925 | 41,979,535 |
| | | | | |
| **Capital & long-term liabilities** | 38,344,201 | 40,465,848 | 40,841,594 | 36,217,763 |
| Called-up share capital | 5,000,000 | 5,000,000 | 5,000,000 | 5,000,000 |
| Retained earnings | 16,027,150 | 17,924,990 | 18,181,620 | 18,224,836 |
| **Net Equity** | 21,027,150 | 22,924,990 | 23,181,620 | 23,224,836 |
| Provisions | 1,543,496 | 1,767,303 | 1,886,419 | 2,219,372 |
| Long-term debt | 15,773,555 | 15,773,555 | 15,773,555 | 10,773,555 |
| **Current liabilities** | 10,880,174 | 6,650,285 | 6,485,331 | 5,761,772 |
| Short-term debt | 3,967,406 | 0 | 0 | 0 |
| Accounts payable | 5,636,350 | 5,557,671 | 5,463,737 | 4,951,133 |
| Other current liabilities | 1,276,418 | 1,092,614 | 1,021,594 | 810,639 |
| **TOTAL CAPITAL AND LIABILITIES** | 49,224,375 | 47,116,133 | 47,326,925 | 41,979,535 |

### Key Observations:

- The Maywood Cycles balance sheet is robust with £23m net equity on a total asset base of £42m.
- The last two years have seen a drastic reduction in long term debt from £15.8m in CY-2 to £5.8m at the end of CY. The two-phase reduction was achieved by the sale and lease-back of the Maywood Warehouse in CY-1 and the negotiation of a short term financing facility with Barclays comprising a £5m invoice discounting facility and a £500k overdraft facility.
- Financial assets/company holdings comprise our 49% stake in the US distribution operation. The controlling 51% of equity is held by Wayne Fairfield.
- Provisions relate to deferred pension contributions. Maywood took advantage of a deferred augmented pension contribution scheme which has been tax advantageous over the last five years but has created a pension liability which must be drawn down by 31st December CY+2.
- Other current liabilities comprise net VAT owed to HMRC. VAT payments are made at the end of each quarter. Maywood uses the VAT cash accounting scheme, i.e. VAT is due for the date on which an invoice is paid rather than the date on which the invoice is issued, explaining a current liability position despite the financial statements being at the end of the quarter.

---

## Financial Information - Cash Flow

| Cash-Flow Statements | CY-4 | CY-3 | CY-2 | CY-1 |
|---|---|---|---|---|
| **Operating cash-flow** | | | | |
| + Revenue | 54,190,576 | 52,026,895 | 50,287,253 | 49,707,771 |
| - COGs | -34,762,243 | -33,346,025 | -33,256,403 | -32,850,775 |
| - Operating costs | -17,027,358 | -14,667,003 | -15,242,813 | -15,074,853 |
| - Change in WCR | -1,206,513 | 2,049,055 | -395,598 | -729,712 |
| + Depreciation | 655,693 | 635,984 | 608,407 | 584,766 |
| **Operating cash flow** | 1,850,155 | 6,698,906 | 2,000,846 | 1,637,197 |
| Discretionary cash flow | 0 | 0 | 0 | 0 |
| - Purchase/Sale of land & buildings (exceptional) | 0 | 0 | 0 | 5,000,000 |
| - Investment in plant & m/c | -350,000 | -485,000 | -372,000 | -627,000 |
| **Non-discretionary cash-flow** | | | | |
| +/- Financial charges | -1,516,418 | -1,311,098 | -1,251,256 | -1,244,759 |
| - Taxation | -299,406 | -581,124 | -161,034 | -161,215 |
| - Dividend | 0 | 0 | 0 | 0 |
| **Cash-flow before financing** | -315,669 | 4,321,684 | 216,556 | 4,604,223 |
| | | | | |
| **Financing** | 0 | 0 | 0 | 0 |
| Equity cash injection | 0 | 0 | 0 | 0 |
| +/- Change in s/t debt | 202,206 | -3,967,406 | 0 | 0 |
| +/- Change in l/t debt | 0 | 0 | 0 | -5,000,000 |
| **NET CASH FLOW** | -113,463 | 354,278 | 216,556 | -395,777 |

### Key Observations:

- Operating cash flows in CY-1 were nearly £1.7m, with cash-flow before financing a healthy £4.6m. The cash generated from the sale of the Maywood Warehouse was used to reduce the long term debt burden.
- The business is expected to generate strong operating cash flows of £1.5m in CY. Provisional free cash flows of £1m in CY, an increase of 20% on the previous period underline the healthy cash generating potential of this company.

---

## Seasonality

- Peak retail demand occurs in the months of May to July as cycling enthusiasts gear up for the summer holidays.
- There is a second retail peak at 80% of the summer boom in December as the Christmas sales are realised.
- January retail sales are at 70% of the peak, reflecting the promotional sales during this period.
- Retail sales are at their lowest in February, 50% of the peak.
- Retail sales are at a second low in October and November, 60% of the peak.
- Retail sales lag Free on Board sales by three months. For Maywood Cycles the peak periods are therefore February to April and September. Because of the payment terms with customers, the cash flow profile of Maywood Cycles does in fact track the retail sales rather closely.
- The seasonality of sales means that Maywood Cycles earns 51% of revenue during the first five months of the year.

---

## Product and Sales Analysis (1/2)

### Number of Units Sold

| Model | CY-4 | CY-3 | CY-2 | CY-1 |
|---|---|---|---|---|
| RACE 1 | 5,642 | 5,375 | 5,156 | 5,040 |
| RACE 1 | 4,265 | 4,093 | 3,927 | 3,828 |
| RACE 1 | 5,746 | 5,468 | 5,292 | 5,186 |
| ROAD 1 | 12,136 | 11,631 | 11,168 | 10,907 |
| ROAD 2 | 15,085 | 14,339 | 13,824 | 13,567 |
| ROAD 3 | 16,944 | 16,020 | 15,475 | 15,139 |
| ROAD 4 | 17,757 | 16,921 | 16,377 | 16,025 |
| MTB 1 | 15,967 | 15,357 | 14,841 | 14,475 |
| MTB 2 | 9,735 | 9,304 | 9,000 | 8,802 |
| MTB 3 | 12,977 | 12,296 | 11,827 | 11,526 |
| MTB 4 | 15,322 | 14,723 | 14,121 | 13,768 |
| CITY - M | 6,413 | 6,054 | 5,837 | 5,704 |
| CITY - F | 11,218 | 10,721 | 10,411 | 10,172 |
| PUSH 1 | 6,706 | 6,383 | 6,161 | 6,040 |
| JR 1 BOY | 8,152 | 7,806 | 7,550 | 7,348 |
| JR 1 GIRL | 6,087 | 5,820 | 5,574 | 5,425 |
| MTB JR 1 BOY | 8,811 | 8,341 | 8,032 | 7,843 |
| MTB JR 1 GIRL | 8,370 | 8,029 | 7,691 | 7,546 |
| **TOTAL** | **187,334** | **178,679** | **172,262** | **168,341** |

### Volume Analysis:

- The management accounts monitor performance of bicycle sales across their product range.
- Race bicycles account for 8% of volumes, road bikes for 33%, mountain bikes for 29%, city bikes for 9% and children bikes for 20%.
- Volumes have decreased by 12-15% since CY-4 and reflects the increased competition in the market.
- Bicycle sales are seasonal with the March to September being the biggest selling season. Christmas sales are also typically good.
- Operational management can analyse sales by bike but has limited information on sales by bike size.

---

## Product and Sales Analysis (2/2)

### Supply Chain Costs and Pricing (£)

| Model | MSRP | Price to Retailers | Price to Wholesalers | COGS |
|---|---|---|---|---|
| RACE 1 | 3,399 | 1,910 | 1,384 | 1,065 |
| RACE 1 | 1,999 | 1,123 | 814 | 627 |
| RACE 1 | 1,499 | 842 | 610 | 470 |
| ROAD 1 | 1,199 | 749 | 441 | 309 |
| ROAD 2 | 899 | 562 | 331 | 231 |
| ROAD 3 | 599 | 374 | 220 | 154 |
| ROAD 4 | 399 | 249 | 147 | 103 |
| MTB 1 | 1,199 | 749 | 441 | 317 |
| MTB 2 | 599 | 374 | 220 | 159 |
| MTB 3 | 499 | 312 | 183 | 132 |
| MTB 4 | 399 | 249 | 147 | 106 |
| CITY - M | 399 | 249 | 147 | 110 |
| CITY - F | 399 | 249 | 147 | 110 |
| PUSH 1 | 99 | 62 | 36 | 29 |
| JR 1 BOY | 99 | 62 | 36 | 29 |
| JR 1 GIRL | 99 | 62 | 36 | 29 |
| MTB JR 1 BOY | 199 | 124 | 73 | 59 |
| MTB JR 1 GIRL | 199 | 124 | 73 | 59 |

### Pricing Analysis:

- For each product category, the frame and fork stays the same and only the components change, going from high to low end. This way, the company can target a wider customer base.
- Race bicycles are the most expensive range and contribute significantly to revenues and margins. The company has historically been sponsoring the Tour de France which is important for its branding and continued success in this product category.
- The company sells more affordable road bicycles for the casual rider and offers a wider range of component choices and prices for all.
- The company started manufacturing mountain bikes like the rest of the industry in the 1980's.
- City bicycles are on the cheaper side of the market and the product range is more limited. Urban cycling has seen a come back in the last couple of years.
- The company offers a range of children bicycles for all ages starting with bicycles with training wheels. These bikes are priced low even if they sometimes require some customised paint jobs as part of marketing campaigns around, for example, movie releases.

---

## Supplier Analysis

| Name | Proportion |
|---|---|
| Zhongshan | 22.27% |
| Mavic | 17.85% |
| SRAM | 16.53% |
| MRP | 7.22% |
| SR | 5.21% |
| MAC | 5.18% |
| Formula | 4.87% |
| Shimano | 4.65% |
| Weinmann | 2.80% |
| FSA | 2.78% |
| Avenir | 2.03% |
| Joytech | 1.88% |
| Raleigh | 1.39% |
| Various | 1.26% |
| Schwalbe | 1.08% |
| Tektro | 1.07% |
| FPD | 1.04% |
| Vittoria Zaffiro | 0.89% |
| KMC | 0.71% |

### Key Points:

- Frames and forks are produced by Zhongshan Forks and Frames in one factory in Daija Taiwan with whom the company has been working for years. Taiwan is the global leader for bicycle manufacturing.
- Mavic is the second largest supplier by value. It is a French company known for its high end bicycle wheels. It supplies the wheels to the race models which are the most expensive in the product catalogue and explains their supplier position.
- SRAM is the third largest supplier. It is based in the USA and emerged in the late 1980's with a revolutionary new gear shifter. It competes with Shimano which is the largest bicycle component manufacturer in the world.
- The company has agreements with many other suppliers in Europe and Asia.

---

## Hire Purchase Agreements

### Key Points:

- Hire purchase agreements are all over 36 months or 48 months. Financed by Acme Amalgamated Financial of Scotland plc at 9% interest.

**Equipment:**

1. **Frame and fork painting bath - Race bike line**
   - Purchased March 1st CY-1
   - £275,000
   - 36 months

2. **Final assembly semi-automated desks - Race bike line**
   - Purchased February 14th CY-2
   - £670,000
   - 48 months

3. **Final assembly semi-automated desks - Road bike line**
   - Purchased February 14th CY-2
   - £780,000
   - 48 months

4. **Final assembly semi-automated desks - Mountain Bike line**
   - Purchased February 14th CY-2
   - £460,000
   - 48 months

5. **Final assembly line belt conveyor and semi-automated assembly desks - Childrens bikes**
   - Purchased October 7th CY
   - £905,000
   - 36 months

---

## Outstanding Loans

### Short Term Debt

- **£500,000 overdraft facility** with Barclays Bank UK.
- **Invoice discounting facility** with Barclays Bank UK. Every purchase order that is received goes to Barclays for invoice discounting. Barclays pays Maywood 85% of the value which is banked as cash. On delivery of the product, the invoice is generated and sent to the customer for payment on terms. When the receivable lands, Barclays keeps 85% as repayment of the advance, keeps 4% as their fee, and pays Maywood the remaining 11%. This facility is limited to £5m and is auto-regulating, i.e. it cannot be breached.

### Long Term Debt

- **£5,773,555 mortgage** with National Westminster UK (NatWest). The loan is a (re)mortgage of the Maywood House and Facility B real estate assets. Victoria House and the Maywood site land remain unencumbered. Victoria House (in need of renovation) and site land are valued at approximately £3m and £5m respectively.

---

## Sales per Country

| Region | Percentage |
|---|---|
| UK | 23% |
| Germany | 16% |
| USA | 12% |
| France | 8% |
| Belgium | 7% |
| Australia | 7% |
| NL | 6% |
| Central Europe | 6% |
| Italy | 5% |
| Spain | 4% |
| South America | 4% |
| Asia | 1% |
| Africa | 1% |

### Key Points:

- The UK remains the largest market with 23% of sales globally.
- Germany, the USA, France, Belgium, Australia and the Netherlands account for an additional 56% and constitute the historical markets for the company.
- The company never managed to sell a lot in Spain and Italy which are also big cycling markets but where local competition is strong.
- Central Europe is starting to pick up as a growth market.
- The company is dabbling with sales in South America, Africa and Asia, mostly the result of opportunistic offers and to check local market traction.

---

## Main Retailers

| Name | Country | Proportion of Sales in Country |
|---|---|---|
| Bike Totaal | NL | 9% |
| Biretco | NL | 7% |
| Zweirad-Stadler | DE | 14% |
| Karstadtsports | DE | 5% |
| Radsport | DE | 2% |
| REI | USA | 28% |
| Decathlon | FR | 1% |
| Go-Sport | FR | 3% |
| Intersport | FR | 6% |
| Sport 2000 | FR | 3% |
| Cicli Tresoldi | IT | 2% |
| InterS | IT | 18% |
| Evans Cycles | UK | 11% |
| Halfords | UK | 9% |
| Cycle Surgery | UK | 11% |
| Chain Reactions | Online | 2% |
| Wiggle | Online | 3% |

> **Note:** Whatever is not sold in the country to retailers is sold through one national distributor, e.g. in NL 16% is sold through retailers so 84% is sold through a national distributor.

### Key Points:

- The company sells through main retailers and national distributors.
- In countries where there are retailers, both retailers and wholesalers buy all of Maywood's products roughly in proportion of its production.
- In countries where there are no retailers, the wholesalers sell 90% race bicycles.
- In the Netherlands, some 16% of sales are through two of the largest bicycle retailers.
- In Germany, the largest customer is Zweirad-Stadler which accounts for nearly 14% of sales.
- In the USA, most of the sales go to REI, a sporting goods retailer, as the country is so big, working through smaller shops is more difficult.
- France has some very powerful sporting retailers like Decathlon who sell mostly their own brands, so sales through these types of channels is proportionally lower than in other countries.
- A contract with the French retailer Intersport with activities in Italy is the main sales channel in that country.
- In the UK, the three largest cycling retail stores account for about 31% of sales.
- The company has over the last few years been trying to sell online mainly in the UK through the two biggest online portals.

---

## Retailer Contracts

| Name | Country | Termination Date | Notice Period | Credit Terms | Other |
|---|---|---|---|---|---|
| Bike Totaal | NL | Initial term of 4 years to 31 December CY+2 | 6 months | 60 days | Failure to meet lead times will result in 25% reduction of total invoice value |
| Biretco | NL | Initial term of 4 years to 31 December CY+3 | 6 months | 60 days | 2% discount to be given on volume of over 5000 bikes in any one year |
| Zweirad-Stadler | DE | Initial term of 3 years to 31 June CY+2 | 4 months | 90 days | Maywood to indemnify all costs, losses and expenses incurred as a result of late delivery |
| Karstadtsports | DE | Initial term of 3 years to 31 December CY+4 | 4 months | 90 days | Maywood to indemnify all costs, losses and expenses incurred as a result of late delivery |
| Radsport | DE | Initial term of 2 years to 31 December CY+1 | 4 months | 60 days | 2% discount to be given on volume of over 5000 bikes in any one year |
| REI | USA | Initial term of 2 years to 31 March CY+3 | 3 months | 60 days | 3% discount to be given on volume of over 5000 bikes in any one year |
| Decathlon | FR | Initial term of 1 year to 31 December CY | 3 months | 45 days | Maywood to indemnify all costs, losses and expenses incurred as a result of late delivery |
| Go-Sport | FR | Initial term of 2 years to 31 December CY+2 | 3 months | 45 days | Failure to meet lead times will result in a deduction of 1% of total invoice value per working day up to a maximum of 5 days |
| Intersport | FR | Initial term of 2 years to 31 December CY+2 | 3 months | 45 days | Failure to meet lead times will result in a deduction of 1% of total invoice value per working day up to a maximum of 5 days |
| Sport 2000 | FR | Initial term of 2 years to 31 December CY+2 | 3 months | 45 days | Failure to meet lead times will result in a deduction of 1% of total invoice value per working day up to a maximum of 5 days |
| Cicli Tresoldi | IT | Initial term of 4 years to 31 March CY+3 | 6 months | 60 days | 2% discount to be given on volume of over 5000 bikes in any one year |
| InterS | IT | Initial term of 2 years to 31 December CY+2 | 3 months | 45 days | Failure to meet lead times will result in a deduction of 1% of total invoice value per working day up to a maximum of 5 days |
| Evans Cycles | UK | Initial term of 5 years to 31 December CY+4 | 12 months | 70 days | Failure to meet lead times will result in 10% reduction of total invoice value |
| Halfords | UK | Initial term of 4 years to 31 March CY | 8 months | 70 days | Failure to meet lead times will result in 10% reduction of total invoice value |
| Cycle Surgery | UK | Initial term of 4 years to 31 December CY+3 | 6 months | 90 days | Failure to meet lead times will result in 25% reduction of total invoice value |
| Chain Reactions | Online | Initial term of 1 year to 31 December CY | 3 months | 30 days | Chain Reactions to cover online marketing costs |
| Wiggle | Online | Initial term of 1 year to 31 December CY | 3 months | 30 days | Chain Reactions to cover online marketing costs |

---

## Main National Distributors

| Country | Distributors |
|---|---|
| UK | Cycling Sports Grouping UK |
| Germany | Shocker Distribution |
| USA | National American Cycling Corporation |
| France | Jean Tullard SAS |
| Belgium | Velo Vermeulen SA |
| Australia | Radical Sports Ltd |
| NL | Global Hotbikes |
| Central Europe | Sacha Cycles |
| Italy | Cicli Moretti |
| Spain | Vuelta Bicicleta |
| South America | South American Import Group |
| Asia | Singapore Technology Company |
| Africa | Massmart Group |

### Key Points:

- The company works through one national distributor per country in order to distribute their bicycles across smaller shops.
- Historically, the company signed exclusive national agreements in each country covering 5 year periods on average with a break clause after 2 years in case of limited performance.
- Apart from Central Europe, South America, Asia and Africa, most of the distributors have been working with the company for a very long time.

---

## Distributor Contracts

| Country | Distributors | Termination Date | Notice Period | Credit Terms |
|---|---|---|---|---|
| UK | Cycling Sports Grouping UK | Initial term of 2 years to 31 December CY+2 | 3 months | 60 days |
| Germany | Shocker Distribution | Initial term of 2 years to 31 December CY+2 | 3 months | 60 days |
| USA | National American Cycling Corporation | Initial term of 3 years to 31 December CY+2 | 6 months | 60 days |
| France | Jean Tullard SAS | Initial term of 4 years to 31 December CY+3 | 6 months | 90 days |
| Belgium | Velo Vermeulen SA | Initial term of 1 year to 31 December CY | 3 months | 60 days |
| Australia | Radical Sports Ltd | Initial term of 3 years to 31 December CY+3 | 12 months | 60 days |
| NL | Global Hotbikes | Initial term of 4 years to 31 December CY+2 | 6 months | 60 days |
| Central Europe | Sacha Cycles | Initial term of 4 years to 31 December CY+3 | 6 months | 60 days |
| Italy | Cicli Moretti | Initial term of 3 years to 31 June CY+2 | 4 months | 90 days |
| Spain | Vuelta Bicicleta | Initial term of 3 years to 31 December CY+3 | 4 months | 90 days |
| South America | South American Import Group | Initial term of 1 year to 31 December CY | 3 months | 60 days |
| Asia | Singapore Technology Company | Initial term of 2 years to 31 December CY+2 | 3 months | 60 days |
| Africa | Massmart Group | Initial term of 2 years to 31 December CY+2 | 3 months | 60 days |

---

## Business Process (1/3)

### Management Reporting Framework

#### Management Accounts

- Full monthly management accounts are produced and issued within eight working days from month end.
- Monthly management accounts with a short covering letter/memo explaining monthly performance, are issued to all directors, main shareholders and banks.
- The management accounts contain a consolidated and divisional profit and loss account, balance sheet and the current month's source and application of funds statement, together with an analysis of stock and overheads. Comparisons are made to budget and last years' comparative. There is no detailed commentary produced and the only commentary is that included in the covering letter/memo.

#### Daily Production Meetings

- The production director will meet with the works manager and factory manager each morning to discuss adverse variances, overnight problems and production scheduling.

#### Job Profitability

- A complete job report detailing cost at standard rates is produced at least monthly. This is reconciled to the actual results per the management accounts each month and used to monitor profitability by customer by job to assist in future price negotiations.

#### Cash Management

- The FD maintains a daily cash report which he uses to monitor the expected overdraft and invoice discounting position.

#### Monthly Management Meetings

- Until this year the Board and main shareholders meet monthly to discuss financial performance, operational issues, strategic plans and capital expenditure plans.

#### Performance Analysis Schedule

- Used by management as a top level indicator of performance against budget.
- Based on number of working days the following is calculated as an average per day and compared to budget:
  - recovery per day
  - average gain per day
  - value added per day
  - costs per day
  - % margin on sales
- Recovery plus average gain per day totals to value added per day.
- % margin on sales is average gain as a percentage of sales. This is effectively the difference between standard recovery and actual value added.

---

## Business Process (2/3)

### Management Reporting Framework

#### Budget Setting

- Budgets are prepared in the autumn of each year.
- In CY-1 a full bottom up process was undertaken to prepare the CY budget given the trading difficulties experienced in the year.
- A full sales budget was prepared for each existing customer considering both volume and price changes anticipated based on discussions with customers and other industry contacts.
- For fixed costs, known changes were factored in such as wage/salary changes.
- Production methods were reviewed and allowance made for the introduction of new machinery. Consequently, the direct cost budget was constructed based on volumes and production plans and resulted in headcount reductions.
- In CY, the CY+1 budget was set based on CY-1 experience. At the time the budget was prepared, management had actual results for the ten months to 31 October CY.
- Sales were budgeted based on current customer portfolio with known/anticipated changes for key customers and market trends.
- As the cost base is substantially fixed, the cost budget was based on CY-1 actuals plus known changes for proposed wage and salary increases and anticipated increases in interest rates. Some efficiency improvements were factored in in respect of improved working practices and benefits from investment in plant.
- Budget setting in both years involved the whole senior management team with the budget being approved by the Board.
- Performance against budget is monitored monthly at a divisional and company level in the monthly management accounts and discussed at management team meetings.

#### Forecasting Procedures

- The forecast for CY is a combination of the actual results to date plus the balance of the CY budget.
- Given that Maywood has performed in line with budget in the seven months ended 31 July CY, this does not appear to be unreasonable.
- The forecasts for CY+1 and CY+2 have been prepared at a high level with none of the detailed work normally undertaken to prepare the budget.
- At its simplest, the forecasts represent a percentage increase in turnover and costs from the CY forecast.
- Forecasts for CY+1 and CY+2 are an executive overview on the basis of limited general assumptions and have not been prepared to the same level of detail as the annual budget.

---

## Business Process (3/3)

### Audit Experience

- Unqualified audit reports were issued for the years ended 31 December CY-2 and CY-1.
- The following matters were raised by the external auditors in association with the CY-1 audit:

#### Fixed Assets
- Fixed asset register is incomplete. A substantial amount of pre CY-5 assets remain unidentified and old plant and equipment in use does not appear on the registers (unidentified net book value negligible).
- VAT incorrectly reclaimed on motor car purchase.

#### Stocks
- Stocktaking procedures need to be enhanced by using a standardised approach in each department and by adhering to strict cut off procedures for stock movements.

#### Debtors
- All deliveries should be promptly invoiced.

#### Bank and Cash
- Bank deposit account postings not kept up to date and account not regularly reconciled.
- Petty cash balance consists of a number of staff advances. Controls required to call in advances. Should be disclosed in 'other debtors'.
- Differences existed between physical and book cash balance at year end. Imprest system recommend.

#### Creditors
- Supplier statement reconciliations not performed regularly.

#### Accounting System
- SAGE nominal ledger model considered weak. Numerous schedules are produced externally to SAGE on spreadsheets.

### Issues Resolved from CY-2

The following matters were raised by the auditors in respect of CY-2 and were not repeated in CY-1. It is therefore assumed that these matters were resolved:

- **Fixed assets:** Fixed asset register did not reconcile to financial statements.
- **Debtors:** Debtors circularisation highlighted disputed items on the sales ledger dating back to CY-3.
- **Bank and cash:** The discounting 'current' account and the bank current account were combined on one nominal ledger code and not regularly reconciled.
- **Management accounts:** Noted that many known and material adjustments were excluded from the monthly management accounts thereby distorting the view of the reader.

---

## Risk Management

| Class | Scope | Interest |
|---|---|---|
| **Combined Commercial** | | |
| Material damage | All risks including theft using forceful entry, sprinkler leakage, subsidence, landslip and ground heave | Buildings £7,845,000; Machinery, Plant and equipment £5,832,907; Stock £6,872,216 |
| Business interruption | As above | Estimated gross profit (24 months) £1,050,000; Additional increased cost of working £5,000,000 |
| Money | All risks of loss or damage in respect of money belonging to the company | Cash £500,000; Money in the form of crossed cheques £2,500,000 |
| Goods in transit | All risks of loss or damage | Estimated amount £3,500,000 |
| **Combined Liabilities** | | |
| Employers liability | Legal liability arising from death, bodily injury or disease to employees occurring in connection with the business | £1,000,000 for any one occurrence |
| Public liability | Legal liability for bodily injury to third parties or physical damage to their property arising in connection with the business | £5,000,000 for any one occurrence (and in aggregate for public liability) |
| Directors and officers liability | To provide an indemnity in respect of claims made during the policy period against the company by reason of a Wrongful Act committed by a director or officer of the company | £1,000,000 any one loss and in aggregate |
| Personal accident | Death or disablement following as a result of an accident | Variable %'s of salary |
