# Loan Note Instrument

## Company

### Instrument Constituting GBP 10,000,000 LIBOR Guaranteed Series A Loan Notes

---

## Contents

| Clause | Subject Matter | Page |
|--------|---------------|------|
| 1. | Definitions and Interpretation | 1 |
| 2. | Amount and Status of Notes | 4 |
| 3. | Interest | 5 |
| 4. | Redemption | 6 |
| 5. | Accelerated Redemption | 7 |
| 6. | Payments | 7 |
| 7. | Certificates | 8 |
| 8. | Register of Noteholders | 8 |
| 9. | Company's Obligations | 9 |
| 10. | Transfer | 9 |
| 11. | Amendments and Meetings of Noteholders | 9 |
| 12. | Notices | 10 |
| 13. | Law and Jurisdiction and Currency | 12 |

### Schedules

| Schedule | Subject | Page |
|----------|---------|------|
| 1. | Certificate | 14 |
| 2. | Conditions | 15 |
| 3. | Events of Default | 21 |
| 4. | Guarantee | 23 |

---

## Loan Note Instrument

**DATE:** TBC

**COMPANY:** [ ], a company incorporated in England whose principal office is at INSEAD (the "Company").

### Background

(A) The Company has pursuant to its Articles of Association and by a resolution of its board of directors created GBP 10,000,000 LIBOR Guaranteed Series A Loan Notes for the following 4 years to be constituted by this Instrument.

(B) The Guarantor has agreed to give the Guarantee.

---

## 1. Definitions and Interpretation

### 1.1 Defined Terms

In this Instrument:

**"Business Day"** means a day (not being a Saturday or Sunday) when banks generally are open in the City of London for the transaction of general banking business;

**"Certificate"** means a certificate for Notes issued in accordance with Clause 8 (Certificates) and in the form or substantially in the form set out in Schedule 1 (Certificate);

**"Conditions"** means the conditions set out in Schedule 2 (Conditions) as from time to time amended or modified in accordance with the provisions of this Instrument;

**"Default Rate"** means 2 per cent per annum above LIBOR;

**"Directors"** means the board of directors of the Company for the time being and "Director" shall be construed accordingly;

**"Events of Default"** means any one or more of the events referred to in Schedule 3 (Events of Default);

**"Extraordinary Resolution"** means a resolution passed at a meeting of the Noteholders duly convened and held in accordance with the provisions of this Instrument by:
- (a) a majority consisting of not less than three-fourths of the persons voting at the meeting on a show of hands; or
- (b) if a poll is demanded, a majority consisting of not less than three-fourths of the votes given on the poll;

**"GBP"** means British Pounds

**"Final Redemption Date"** means 20 December four years from signing;

**"Guarantee"** means the guarantee in Schedule 4 (Guarantee);

**"Guarantor"** means HSBC PLC a company incorporated under the laws of Scotland, acting through its London Branch at Bishopsgate, London;

**"Interest Payment Date"** means 31 January, 30 April, 31 July, 31 October in each year;

**"Interest Period"** means as the case may be the period from and including the date of first issue of the Notes up to (but excluding) the next following Interest Payment Date and the period from and including any Interest Payment Date up to (but excluding) the next following Interest Payment Date;

**"LIBOR"** means the interest rate for deposits in Sterling for a period of three months which appears on the Telerate page 3750 (or such other page as the parties may agree) at approximately 11.00 am London time on the first day of the period to which any interest period relates (the "Relevant Date"). If such rate does not appear on the Telerate page 3750 on the Relevant Date then the rate shall be taken as at the rate appearing on Telerate page 3750 on the nearest Business Day following the Relevant Date;

**"Maywood"** means Maywood of Nottingham Limited;

**"Nominated Noteholder"** means _________________ (CEO) or failing him, ____________________ (CFO), or failing him any other Noteholder notified to the Company by the Noteholders as appointed by them pursuant to an Extraordinary Resolution;

**"Noteholder"** means a person for the time being entered in the Register as a holder of a Note;

**"Notes"** means the GBP 10,000,000 LIBOR Guaranteed Series A Loan Notes for the duration of the loan of the Company constituted by this Instrument or, as the case may be, the amount of those notes for the time being issued and outstanding;

**"Outstanding Notes"** means any of the Notes which have been issued but not redeemed or purchased by the Company;

**"Proceedings"** means any proceedings, suit or action arising out of or in connection with this Instrument;

**"Redemption Date"** means each of 20 June on the start year, 20 December the second to last year and the Final Redemption Date;

**"Register"** means the register of Noteholders referred to in Clause 8.1 (Register);

**"Sale and Purchase Agreement"** means the sale and purchase agreement dated [ ] December of the year preceding the start one between (1) the Sellers (as defined in that agreement) and (2) the Company for the purchase by the Company of the entire issued share capital of Maywood;

**"Security Interest"** means any debenture, mortgage, charge, pledge, lien, assignment hypothecation, right of set-of GBP or combination of accounts, title retention or other arrangement or agreement the effect of which is the creation of security.

### 1.2 Contents Page and Headings

In this Instrument, the contents page and headings are included for convenience only and shall not affect the interpretation or construction of this Instrument.

### 1.3 Meaning of References

In this Instrument, unless the context requires otherwise, any reference in this Instrument, any Schedule or the Conditions to:

(a) a **Clause** or a **Schedule** is to a clause of or a schedule to this Instrument and to a Paragraph of a Schedule is to a paragraph of that Schedule;

(b) this **Instrument** includes the Schedules, which form part of this Instrument;

(c) a **statute** or **statutory provision** includes any consolidation or re-enactment, modification or replacement of the same, any statute or statutory provision of which it is a consolidation, re-enactment, modification or replacement and any subordinate legislation in force under any of the same from time to time;

(d) the **masculine**, **feminine** or **neuter** gender respectively includes the other genders and any reference to the singular includes the plural (and vice versa);

(e) references to a **company** shall be construed so as to include any company, corporation or other body corporate wherever and however incorporated or established;

(f) **"subsidiary"** and **"holding company"** shall have the respective meanings given to those expressions by s736 of the Companies Act 1985;

(g) a **person** includes any individual, firm, corporation, unincorporated association, government, state or agency of state, any association or partnership or joint venture (whether or not having a separate legal personality);

(h) any **English statutory provision** or **English legal term** for any action, remedy, method of judicial proceeding, document, legal status, court, official or any other legal concept or thing shall in respect of any jurisdiction other than England be deemed to include what most nearly approximates in that jurisdiction to the English statutory provision or English legal term;

(i) **writing** shall include any modes of reproducing words in a legible and non-transitory form;

(j) **Sterling** or **GBP** or **pounds** is to the lawful currency of the United Kingdom;

(k) a **time of the day** is to London time and references to a **day** are to a period of 24 hours running from midnight to midnight; and

(l) **redemption** includes repayment and purchase and vice versa and the words redeem, repay, redeemable, repayable, repaid, redeemed and purchased shall be construed accordingly.

### 1.4 No Restrictive Interpretations

In this Instrument, general words shall not be given a restrictive interpretation by reason of their being preceded or followed by words indicating a particular class of acts, matters or things.

---

## 2. Amount and Status of Notes

### 2.1 Issue of Notes

The Notes shall be issued at Completion pursuant to the Sale and Purchase Agreement. All the obligations and covenants contained in this Instrument shall be binding on the Company and the Noteholders and their successors, permitted assigns and all persons claiming through them.

### 2.2 Further Loan Capital

So long as the Guarantee remains in effect, the Company reserves the right to create and issue at its discretion from time to time further loan capital ranking in priority to or pari passu with or subordinated to the Notes whether secured or unsecured, for cash or otherwise, at par or at a premium or at a discount and with or without rights of conversion into or subscription for shares of the Company and carrying such rights as to premium, interest, maturity, repayment and otherwise as the Company shall think fit.

### 2.3 Amount of Notes

The principal amount of the Notes is limited to **GBP 10,000,000**. The Notes shall be issued in denominations and integral multiples of **GBP 10,000** in nominal amount, subject to and with the benefit of the provisions of this Instrument.

### 2.4 Pari Passu Obligations

Subject to the Guarantee, the Notes shall rank pari passu with the B Notes and all others as unsecured bank-guaranteed obligations of the Company.

### 2.5 Cancellation of Notes

All Notes redeemed by the Company under the provisions of this Instrument shall be cancelled and shall not be re-issued.

---

## 3. Interest

### 3.1 Rate of Interest

The Notes will carry interest at **LIBOR**.

### 3.2 Number of Days in Each Year

Interest shall be calculated on the basis of a year of **365 days** and for the actual number of days elapsed and shall accrue from day to day.

### 3.3 Payment of Interest

Accrued interest on the Notes shall be payable by equal quarterly instalments in arrears on each Interest Payment Date on all of the Outstanding Notes.

### 3.4 Interest on Overdue Amounts

Interest will be charged on any amounts payable in respect of the Notes (whether principal, interest or otherwise) not paid when due. Such interest shall accrue from the due date for payment until the date of actual payment (after as well as before any judgment). Such interest shall be calculated at the **Default Rate** and Clause 3.2 (Number of days in each year) shall apply to it. Such default interest shall be payable on demand and shall be compounded monthly. The Company shall notify the Nominated Noteholder within a reasonable period of it becoming aware that any amount payable by the Company pursuant to the Notes has not been paid when due.

---

## 4. Redemption

### 4.1 Repayment and Redemption of Notes

Subject to Clause 4.2 below, each Noteholder may, by written notice (which shall be irrevocable) to be given on his behalf by the Nominated Noteholder and sent to the Company (the "Redemption Notice"), not earlier than 60 days and no later than 31 days prior to any Redemption Date, require the Company to redeem, on the relevant Redemption Date below, an amount of up to the lesser of the amount outstanding on the Notes held by the relevant Noteholder and the following applicable percentages of the aggregate amount of the Notes held by all of the Noteholders, on a cumulative basis:

| Redemption Date | Maximum % | Cumulative % |
|-----------------|-----------|--------------|
| 20 June year 1 | up to 30% | 30% |
| 20 December year 3 | up to 35% | 65% |
| 20 December year 4 | up to 35% | 100% |

In each case the amount to be redeemed being the full amount so permitted or part thereof (being the amount outstanding (if less than GBP 10,000) or GBP 10,000 in nominal amount (or an integral multiple of that amount)) of the Notes held by the Noteholders together with accrued interest (subject to any requirement to deduct any tax therefrom) up to (but excluding) the relevant Redemption Date. The Redemption Notice shall specify the amount if any, of Notes to be redeemed by each Noteholder and the Company shall be entitled to rely on the Redemption Notice as representing both a valid request on behalf of, and the position agreed by, the Noteholders. If the Company makes redemption payments in accordance with the Redemption Notice, no Noteholder will have any claim against the Company for failure to repay any amounts under the Notes.

### 4.2 Final Redemption

On the Final Redemption Date, all Outstanding Notes shall be redeemed at par together with accrued interest (subject to any requirement to deduct any tax therefrom), without the requirement for any notice under Clause 4.1 above.

---

## 5. Accelerated Redemption

On or at any time after the occurrence of one or more Events of Default, the Noteholders may elect as decided by them by Extraordinary Resolution to require all or some of the Notes to become immediately redeemable at par together with accrued interest and all other moneys due and payable under this Instrument.

---

## 6. Payments

### 6.1 Making of Payments

All moneys (whether of principal or interest) payable in respect of Notes to be redeemed, on the Final Redemption Date or earlier, repaid or purchased by the Company only with the agreement of Noteholders pursuant to Clause 2.2 of Schedule 2 (Conditions) shall be:

(a) in the absence of any notice from the Noteholder pursuant to sub-clause (b), paid by cheque or warrant sent by pre-paid first class post to the registered address of the Noteholder (or in the case of joint holders to the joint holder whose name appears first in the Register) or to such person at such address as the Noteholder may by notice to the Company direct; or

(b) paid to the Noteholder's account at such office or bank as he may notify to the Company from time to time. Such monies shall be paid in immediately available French Francs.

### 6.2 Payments Due on Non-Business Days

If any payment is due on a non-Business Day, the due date for payment shall instead be the next Business Day unless that is in the next calendar month, in which case it shall be the preceding Business Day.

### 6.3 Payments to be Made in Full

All payments made or to be made by the Company under this Instrument shall be made in full.

### 6.4 Deductions Required by Law

If the Company is compelled by applicable law to make payment subject to any deduction or withholding in respect of tax, then it shall:

(i) account for the same to the relevant tax authority as and when required by law; and

(ii) promptly provide to the Noteholder a certificate of deduction and any tax receipts and other documents as the Noteholder may reasonably require.

---

## 7. Certificates

The Company shall issue and deliver, at its own cost, a duly executed Certificate to each Noteholder for the Notes held by him. Joint Noteholders shall be entitled to hold only one Certificate in respect of the Notes held jointly by them and delivery of that Certificate to the joint Noteholder whose name appears first in the Register shall be sufficient delivery to all the joint Noteholders. Each Certificate shall have endorsed on it or attached to it the Conditions.

---

## 8. Register of Noteholders

### 8.1 Register

The Company shall at all times maintain a register at the registered office of Maywood or at such other place in England as it may from time to time decide, in which shall be entered the names and addresses of the holders for the time being of the Notes together with the principal amounts of their respective holdings of Notes, the date upon which they were registered as Noteholders, the serial number of each Certificate issued and its date of issue.

### 8.2 Change in Details

Each Noteholder shall notify the Company of any change of name and address and the Company shall upon receiving the notification alter the Register accordingly.

### 8.3 Inspection of Register

The Register shall at all reasonable times be open for inspection by the Noteholders or any of them or, in the case of a corporation, by any person authorised in writing by the Noteholder.

---

## 9. Company's Obligations

The Company covenants with the Noteholders that it will duly perform and observe all the covenants, conditions, provisions and obligations on its part contained in this Instrument and the Conditions.

---

## 10. Transfer

### 10.1 Transferability

The Notes will be in registered form and, subject to Clause 10.2, transferable after the Final Claims Date.

### 10.2 Amount Capable of Transfer

The Notes are transferable in whole or in part in multiples of **GBP 10,000**.

### 10.3 Notice of Transfer

Any proposed transfer of Notes by a Noteholder shall be subject to the transferor Noteholder having given **30 (thirty) days** prior notice to the Company of the proposed transfer.

### 10.4 Transfer by the Company

The Company may assign any of its rights (but not its obligations) under or in connection with the Notes or the Instrument provided that such assignment does not affect the Guarantee which shall remain in full force and effect.

---

## 11. Amendments and Meetings of Noteholders

### 11.1 Amendments

The provisions of this Instrument may be amended with the consent in writing of the Company and the Guarantor together with an Extraordinary Resolution consenting thereto.

### 11.2 Extraordinary Resolutions

Any Extraordinary Resolution shall be binding on all the Noteholders. A resolution in writing signed by all the Noteholders shall be valid and effective as if it had been passed as an Extraordinary Resolution.

### 11.3 Meetings of Noteholders

The Company may, and on the requisition of the holders of 20% in principal amount of the Notes then outstanding shall, convene a meeting of the Noteholders. Any meeting of the Noteholders shall (subject to the terms of this Instrument) be convened, conducted and held in all respects as nearly as possible in the same manner as is provided by the articles of association of Maywood from time to time Provided that:

(a) no person shall be entitled to receive notice of or to attend or speak at any meeting of the Noteholders unless he is a Noteholder;

(b) the quorum at any meeting of the Noteholders shall be two Noteholders present in person or by proxy (or, being a corporation, represented by a duly authorised representative) and holding not less than **one-tenth** in principal amount of the Outstanding Notes;

(c) a poll may be demanded by the chairman of the meeting or a Noteholder (or Noteholders) present in person or by proxy (or, being a corporation, represented by a duly authorised representative) and holding not less than one-tenth in principal amount of the Outstanding Notes;

(d) on a show of hands, each Noteholder present in person or by proxy (or, being a corporation, represented by a duly authorised representative) shall have **one vote**;

(e) on a poll, each Noteholder present in person or by proxy (or, being a corporation, represented by a duly authorised representative) shall have **one vote for every GBP 10,000** in principal amount of the Outstanding Note or Notes of which he is a holder; and

(f) in the case of an equality of votes, the chairman shall **not** have a casting vote.

---

## 12. Notices

### 12.1 Form of Notices

All notices and other communications relating to this Instrument:

(a) shall be in English and in writing;

(b) in the case of notices to the Company or the Guarantor, shall be delivered by hand or sent by pre-paid post to the relevant address and marked as shown in Clause 12.2;

(c) in the case of the Nominated Noteholder or any Noteholder, shall be delivered by hand or sent by prepaid first class post to the address of the Noteholder shown on the Register (and in the case of joint holders of Notes, the registered address of the first named on the Register);

(d) shall take effect:
- (i) if delivered, upon delivery;
- (ii) if posted, at 10:00 a.m. on the first Business Day after posting;

Provided that if any communication would otherwise become effective on a non-Business Day or after 5 p.m. on a Business Day, it shall instead become effective at 10 a.m. on the next Business Day. s196 Law of Property Act 1925 shall not apply to this Instrument.

### 12.2 Initial Details of the Company and the Guarantor

The initial details of the Company and the Guarantor for the purposes of Clause 12.1 are:

**(a) the Company**
- Address: _____________________________
- Facsimile No: _____________________________
- Attention of: _____________________________

**(b) the Guarantor**
- Address: HSBC
- Facsimile No:
- Attention of: Your Banker

### 12.3 Changes to Details

(a) Each of the Company and the Guarantor may notify the Noteholders of a change to its name, relevant addressee or address for the purposes of this Clause 12 provided that that notification shall take effect on the date specified in the notification as the date on which the change is to take place or, if no date is specified or the date specified is less than 10 Business Days after the date on which notice is given, the date falling 10 Business Days after the date on which notice is given.

### 12.4 Notice to Personal Representatives

If any Noteholder (being an individual) dies, then until receipt by the Company of a certified copy of the grant of representation to the estate of the deceased, any notice or other communication addressed to the deceased or to his personal representatives and sent or delivered in accordance with this Clause 12 (Notices) shall for all purposes be deemed sufficient service of that notice or other communication on the deceased and his personal representatives and shall be effectual as if the deceased were still living.

---

## 13. Law and Jurisdiction and Currency

### 13.1 Governing Law

This Instrument shall be governed by and construed in accordance with **English law**.

### 13.2 Jurisdiction

For the exclusive benefit of the Company, the courts of England are to have exclusive jurisdiction to settle any disputes which may arise out of or in connection with this Instrument and accordingly any proceedings may only be brought in those courts.

### 13.3 Currency

As the lawful currency of England is the British Pound (GBP), the currency for this and all associated transactions pertaining to this Instrument is the same.

---

## EXECUTION

The Company has executed and delivered this Instrument as a deed at the end of the Schedules.

---

# Schedule 1: Certificate

**[ ]. (the "Company")**

No. .............. Amount GBP ...........................

**ISSUE of up to GBP 10,000,000 LIBOR Guaranteed Series A Loan Notes.**

Created and issued pursuant to the Company's Articles of Association and a resolution of its board of directors passed on 20 December last year.

THIS IS TO CERTIFY that [name of Noteholder] of [address] is/are the registered holder(s) of GBP [ ] nominal of the LIBOR Guaranteed Series A Loan Notes ("Notes") which Notes are constituted by an instrument entered into by the Company on and dated 20 December last year (the "Instrument") and are issued subject to and with the benefit of the provisions contained in that Instrument and to the conditions attached to this Certificate.

**SIGNED** as a deed by [ ]
Director and by [ ]
Director/Secretary
duly authorised for and on behalf of

---

# Schedule 2: Conditions

The Instrument is as defined on the Certificate attached to these Conditions. Words and expressions defined in the Instrument (of which these Conditions form a part) but not defined in these Conditions shall have the same meaning in these Conditions as in the Instrument.

## 1. Interest

### 1.1 Rate of Interest

The Notes will carry interest at **LIBOR**. Such interest shall be calculated on the basis of a year of 365 days and for the actual number of days elapsed and shall accrue from day to day. Accrued interest on the Notes shall be payable by equal quarterly instalments in arrears on 31 January, 30 April, 31 July, 31 October in each year.

### 1.2 Default Interest

Interest will be charged on any amounts payable in respect of the Notes (whether principal, interest or otherwise) not paid when due. This interest shall accrue from day to day and from the due date for payment until the date of actual payment (after as well as before any judgment). It shall be calculated at the rate of **2 per cent per annum above LIBOR**. This default interest shall be payable on demand and shall be compounded monthly.

## 2. Redemption

### 2.1 Date of Redemption

On the Final Redemption Date, all Outstanding Notes shall be redeemed at par together with accrued interest and all other moneys due and payable under the Instrument.

### 2.2 Purchase of Notes by the Company

The Company may, with the written agreement of the Noteholder, at any time purchase any Outstanding Notes by tender (available to all Noteholders proportionally alike) or by private treaty or otherwise at any price agreed between the Noteholder and the Company.

### 2.3 Accelerated Redemption

On or at any time after the occurrence of one or more Events of Default, the Noteholders may elect by Extraordinary Resolution the Notes shall become immediately redeemable at par together with accrued interest and all other moneys due and payable under the Instrument.

### 2.4 Payments

The principal moneys and any other amounts payable in respect of the Notes may be paid by cheque or bank draft sent by pre-paid post to the registered address of the Noteholder (or in the case of joint holders to the joint holder or to such person and address as the Noteholder may in writing direct. Any Noteholder may by notice in writing direct the Company to make that payment to the credit of a bank in the United Kingdom or elsewhere (at the cost of such Noteholder) in which event that payment shall be made in immediately available funds for credit to the Noteholder's account at the office or bank designated by him in that notice.

### 2.5 Payments to be Made in Full

Any and all payments made or to be made by the Company under these provisions shall be made in full. If the Company is compelled by law to make payment subject to any deduction or withholding in respect of tax, it shall (subject to the terms of Clause 6.5 of the Instrument (Deductions required by law)) gross up that payment by such amount as shall ensure that the Noteholder receives the full amount which it would have received had there not been any such deduction or withholding.

## 3. Transfer of Notes

### 3.1 Transferability

The Notes will be in registered form and, subject to Clause 3.2, transferable.

### 3.2 Amount Capable of Transfer

A Noteholder may transfer the whole (or any part) in multiples of GBP 10,000 of the Notes he holds (or the balance of his Notes if less than GBP 10,000).

### 3.3 Transfer Instrument

A transfer of a Note shall be by an instrument in writing under the hand of the transferor in any usual or common form or in any other form approved by the Directors.

### 3.4 Registration of Transfer

Every instrument of transfer shall be lodged with the Company together with the Certificate to be transferred and such other evidence as the Directors may require to prove the title of the transferor or his right to transfer all or part of the Notes. Each transfer so lodged (but no other transfer) shall be registered and an entry of the registration made in the Register. The Company shall accordingly issue a new certificate to the transferee for the Notes transferred. The transferor shall be deemed to remain the owner of the Notes to be transferred until the name of the transferee is entered in the Register in respect of those Notes. The Company shall be entitled to retain the instrument of transfer. In the event of a transfer of only part of the Notes held by a Noteholder, a Certificate shall be issued to such Noteholder for the balance of that Noteholder's Outstanding Notes.

### 3.5 Transmission

Any person entitled to all or part of the Notes by reason of the death, bankruptcy or liquidation (as appropriate) of any Noteholder or otherwise by operation of law may upon producing such evidence of his title as the Company may reasonably require be registered as the holder of all or part of the same or, subject to the provisions of the Conditions governing transfer, may transfer the same. The Company may in its sole discretion retain any payments on or in respect of the Note until the person entitled under this Condition 3.5 has been duly registered.

### 3.6 Title to Notes

The Company shall recognise the registered holder of any Notes as the sole absolute owner of the Notes and as alone entitled to receive and give effectual discharges for the moneys due in respect of those Notes. The Company shall not be affected by notice of any trust whether express, implied or constructive to which any Notes may be subject and shall not be affected by any notice it may have whether express or constructive of the right, title or claim of any other person other than the Noteholder to or in those Notes or moneys.

### 3.7 Recognition of Executors etc.

On the death of a sole registered Noteholder, the Company shall recognise the executors and administrators of that Noteholder as the only person having any title or interest in that Note. On the death of one or more of joint registered holders of a Note, the Company shall recognise the survivor or survivors of joint registered holders as the only person or persons having any title or interest in that Note.

## 4. Replacement Certificates

### 4.1 Lost, Worn-out or Defaced Certificate

If any Certificate is worn out or defaced, then upon production of it to the Directors, they shall cancel the same and issue a Certificate in lieu of it. If any Certificate is lost or destroyed, then upon proof of the same being given to the reasonable satisfaction of the Directors, or in default of that proof, on such terms as to evidence and indemnity and the payment of reasonable out-of-pocket expenses of the Company in investigating the evidence as the Directors may reasonably deem adequate, a new Certificate in lieu of it may be given to the person entitled to that lost or destroyed Certificate. An entry as to the issue of the new Certificate and indemnity (if any) shall be made in the Register.

### 4.2 Surrender of Certificates

If any Noteholder whose Notes (or any of them) are liable to be redeemed shall fail or refuse to deliver up his Certificate to the Company for cancellation (or, as the case may be, replacement by a new Certificate for the remaining Notes or part thereof held by him following that redemption) within 15 Business Days after the date for redemption of the Notes in question or shall fail or refuse to accept payment of the redemption moneys payable in respect of those Notes, the Company shall be at liberty to deposit in a bank in an interest bearing account in the name of the Noteholder the amount payable to that Noteholder and on such deposit or payment being made the Notes which the Company is ready to redeem shall be deemed to have been redeemed in accordance with the provisions of the Instrument.

## 5. Amendments and Meetings of Noteholders

### 5.1 Amendments

The provisions of the Instrument may be amended with the consent in writing of the Company and the Guarantor together with the consent of an Extraordinary Resolution.

### 5.2 Extraordinary Resolutions

Any Extraordinary Resolution shall be binding on all the Noteholders. A resolution in writing signed by all the Noteholders shall be valid and effective as if it had been passed as an Extraordinary Resolution.

### 5.3 Meetings of Noteholders

The Company may, and on the requisition of the holders of 20% in principal amount of the Outstanding Notes shall, convene a meeting of the Noteholders. Any meeting of the Noteholders shall (subject to the terms of the Instrument) be convened, conducted and held in all respects as nearly as possible in the same manner as is provided by the articles of association of Maywood from time to time, Provided that:

(a) no person shall be entitled to receive notice of or to attend or speak at any meeting of the Noteholders unless he is a Noteholder;

(b) the quorum at any meeting of the Noteholders shall be two Noteholders present in person or by proxy (or, being a corporation, represented by a duly authorised representative) and holding not less than one-tenth in principal amount of the Outstanding Notes;

(c) a poll may be demanded by the chairman of the meeting or a Noteholder (or Noteholders) present in person or by proxy (or, being a corporation, represented by a duly authorised representative) and holding not less than one-tenth in principal amount of the Outstanding Notes;

(d) on a show of hands, each Noteholder present in person or by proxy (or, being a corporation, represented by a duly authorised representative) shall have one vote;

(e) on a poll, each Noteholder present in person or by proxy (or, being a corporation, represented by a duly authorised representative) shall have one vote for every GBP 10,000 in principal amount of the Note or Notes of which he is a holder; and

(f) in the case of an equality of votes, the chairman shall have a casting vote.

## 6. Notices

### 6.1 Notices

Any notice or other communication to be given to any Noteholder shall be in English and writing and shall be delivered by hand or sent by pre-paid first class to its registered address (and in the case of joint holders, to the registered address of the first named on the Register). Any notice shall take effect, if delivered by hand, on delivery and, if posted, at 10.00 a.m. on the first Business Day after posting.

### 6.2 Noteholder Outside the UK

A Noteholder who (having no registered address within the United Kingdom) has not supplied to the Company an address within the United Kingdom for the service of notices shall not be entitled to receive any notice from the Company.

---

# Schedule 3: Events of Default

1. The Company fails to pay, on the due date, any moneys (whether principal or interest) payable to a Noteholder under any of the Notes and that failure is not remedied within **ten (10) Business Days** after the Nominated Noteholder or the relevant Noteholder has served a demand in writing on the Company in respect of the same.

2. An order is made or an effective resolution is passed for the winding up of the Company (other than for the purpose of a reconstruction or amalgamation the terms of which have previously been approved in writing by the Nominated Noteholder or a members' voluntary winding up with the consent of the Nominated Noteholder).

3. Without the previous consent of the Nominated Noteholder, the Company ceases all or a material part of its business (as conducted by it on the date of the Sale and Purchase Agreement).

4. Any encumbrancer takes possession of or an administrative receiver or administrator or the equivalent in England or elsewhere is appointed over any material part of the undertaking, property and assets of the Company.

5. A distress, execution or sequestration is levied or enforced or issued against any of the assets of the Company (or the equivalent in England or elsewhere) which is not discharged within **twenty (20) Business Days**.

6. The Company is unable to pay its debts, or is believed to be highly likely to default on its debts, within the meaning of s123(1)(a) of the Insolvency Act 1986.

7. A proposal for a voluntary arrangement is made to the Company and its creditors pursuant to s1 of the Insolvency Act 1986 (or the equivalent in England or elsewhere) save for where such a proposal is made pursuant to a reorganisation of the Company.

8. A petition is presented for an administration order to be made in respect of the Company under the Insolvency Act 1986 (or the equivalent in England or elsewhere).

9. The Company shall default in the observance or performance of any material provision of any of the Notes (other than a provision relating to the payment of principal money or interest) and if that default shall be capable of remedy or, fails to remedy the same within **twenty (20) Business Days** of notice given by the relevant Noteholder to the Company requiring the same to be remedied.

10. **The company loses customers that represent greater than 20% of the company's revenues.**

11. The Guarantee ceases to be valid and effective.

12. **The outstanding loan amount payable shall be then the responsibility fully and severally by each member of the Maywood management team.**

---

# Schedule 4: Guarantee

## THIS DEED OF GUARANTEE

(the "Guarantee") is dated [ ] December last year and made by **HSBC plc**, acting through its London branch (the "Guarantor") in favour of the Noteholders (as defined below)

## 1. Background

(A) Pursuant to a loan note instrument of even date herewith (the "Instrument") ______________________. (the "Company") has issued GBP 10,000,000 Guaranteed Series A Loan Notes in favour of the Noteholders as defined therein.

(B) The Company has requested the Guarantor to guarantee payment of principal and interest under the Notes (as defined in the Instrument) to the Noteholders on the terms and conditions of this Guarantee.

(C) Terms and expressions defined in the Instrument shall have the same meanings when used in this Guarantee.

## 2. Guarantee

Subject to the remaining provisions of this Guarantee, the Guarantor unconditionally and irrevocably guarantees to each Noteholder the due and punctual payment by the Company of the principal amount of the Notes held by him and payment of all interest due and payable on those Notes under clause 3 of the Instrument (the "Guaranteed Amounts"), provided that the aggregate liability of the Guarantor shall not exceed the principal amount of the Outstanding Notes, together with interest payable on the principal amount of the Outstanding Notes pursuant to clause 3.1 of the Instrument.

**If the Company is in default, management jointly and severally will become the guarantors of the Notes. Thereafter Guarantor will be the Management Team.**

## 3. Demand

(A) If the Company shall be in default in the payment on the due date of any Guaranteed Amounts, the Guarantor shall, subject to and upon first written demand by the Noteholder, pay to such Noteholder the amount in respect of which such default has been made and any payment so made shall pro tanto make good such default on the part of the Company. Such payment shall be made within **fourteen (14) days** after the service upon the Guarantor of such written demand.

(B) A demand under this Guarantee must be made within **six (6) months** of the sum concerned becoming due from the Company and the liability of the Guarantor shall end on **5 years from Completion plus six months**, but without prejudice to any demand which is served and received prior to the close of business on the expiration of such six month period or such expiry date.

## 4. Continuing Guarantee

This Guarantee:

(A) is a continuing guarantee and (subject to the expiry provisions of Paragraph 3(B)) shall remain in force and effect until the Company has performed and discharged all of its obligations in respect of the Guaranteed Amounts; and

(B) is additional to (and not in substitution for) any other security or guarantee which is or may be held by any of the Noteholders from time to time in respect of the obligations of the Company under the Instrument.

## 5. No Release

The Guarantor's liability under this Guarantee shall not be affected by:

(A) any concession, time, indulgence or release granted by all or any Noteholders or by any payment or other dealing or anything else (whether by or relating to the Company, any co-guarantor or any other person) which would, but for this Clause 5, operate to discharge or reduce that liability; or

(B) any variation, determination, renewal, replacement, transfer or substitution of any Note,

provided that none of the foregoing shall increase the Guarantor's liability under this Guarantee nor prejudice its rights and remedies as guarantor.

## 6. Invalidity or Unenforceability of Guarantee

If anything (including any legal limitation, disability, liquidation or other incapacity on the part of the Company or any disclaimer by a liquidator) causes any of the Company's payment obligations in respect of the Guaranteed Amounts to be or become invalid or unenforceable, then the Guarantor shall perform and discharge all of the Company's payment obligations as if they were the primary obligations of the Guarantor.

## 7. Enforcement

Any Noteholder may claim under the Guarantee without first making demand of the Company or taking any action to claim under or enforce any other right, security or other guarantee which it may hold from time to time in respect of the Company's obligations under the Instrument, provided that no Noteholder may make any demand on the Guarantor under this Guarantee (and so the Guarantor's liability under this Guarantee shall not arise) unless and until that Noteholder has notified the Company and the Guarantor of the Company's failure to perform the relevant obligation or obligations and that failure has not been remedied by the Company or the Guarantor within **ten (10) working days** after the date on which that notice is given.

## 8. Tax

The Guarantor shall be entitled to deduct tax from payments due from it under this Guarantee if so required by law and, to the extent that such deduction is required in respect of such payments, the Guarantor shall be under no obligation to increase its payments.

## 9. Substitute Guarantor

(A) The Guarantor may at any time, with the prior written consent of the Nominated Noteholder and the Company, substitute a bank to act as guarantor in place of the Guarantor, provided the consent of the Nominated Noteholder and the Company shall not be withheld if the proposed bank (i) is of no lesser credit rating at the time of substitution than the Guarantor and (ii) has offices, a branch and assets in the United Kingdom. The above substitution shall be effected by the execution of a deed supplemental to this Guarantee by the substitute guarantor whereupon the Guarantor shall be released from its obligations under this Guarantee and the substitute guarantor shall become liable to the Noteholders in all respects as if it had executed this Guarantee and was named in it as the Guarantor and this Guarantee shall thenceforth have effect as if all references to the "Guarantor" were references to the substitute guarantor.

(B) The provisions of Clause 8 shall apply to any payments by the substitute guarantor.

## 10. Notices

(A) Any notice (which term shall in this Clause 10 include any demand and any other communication) to be given by one person to another under this Guarantee or in connection with the matters contemplated by it shall, except where otherwise specifically provided, be in writing.

(B) Any such notice shall be delivered or sent to the intended recipient at its address or facsimile number, and marked for the attention of its department or officer, as the case may be, as provided in Paragraph 10(C) and may be:

(i) personally delivered, in which case it shall be deemed to have been given upon delivery at the relevant address but, if it is so delivered other than between 9.00 a.m. and 5.00 p.m. on a working day, it shall be deemed to have been given when 9.00 a.m. on a working day next occurs following such delivery; or

(ii) if sent from and addressed to places within the United Kingdom, sent by recorded delivery, in which case, it shall be deemed to have been given at 9.00 a.m. on the second working day after the date of such posting; or

(iii) if sent from or addressed to any place outside the United Kingdom, sent by pre-paid airmail, in which case, it shall be deemed to have been given at 9.00 a.m. on the seventh working day after the date of such posting; or

(iv) sent by facsimile, in which case, subject to confirmation of uninterrupted transmission by a transmission report, such notice shall be deemed to have been given upon the completion of its despatch, provided that if such completion takes place other than between 9.00 a.m. and 5.00 p.m. on a working day it shall (subject as aforesaid) be deemed to have been given when 9.00 a.m. on a working day next occurs following such completion.

(C) The addresses and other details referred to in Paragraph 10(B) are, subject to Paragraph 10(D):

**The Guarantor:**
- HSBC plc
- Leveraged Finance Group
- London, UK
- Attention of:
- Fax:

**The Company:**
- Attention of:
- Fax:

**The Nominated Noteholder:**
- Attention of: -
- Fax:

(D) Each party to this Guarantee may notify each other of any change to its address or any of its other details specified in Paragraph 10(C), provided that such notification shall only be effective on the date specified in such notice or fifteen (15) working days after the notice is given, whichever is later.

(E) In proving that any such notice was personally delivered, an affidavit sworn by the person making such delivery shall be sufficient evidence of proper delivery for all purposes. In proving that any such notice was posted, it shall be sufficient to prove that the envelope containing such notice was properly addressed, stamped and put in the post.

(F) As used in this Clause 10, the expression "working day" means any day which is not a Saturday or a Sunday or a public holiday in the place to which the relevant notice is sent and the expression "working days" shall be construed accordingly. All references therein to times of day are references to times in that place. For the purposes of this Guarantee, any notice received by one person from another shall be treated as having been received at the time when it is deemed to have been given in accordance with this Clause 10.

## 11. Governing Law and Jurisdiction

(A) This Guarantee shall be governed by, and construed in accordance with, **English law**.

(B) With respect to any suit, action, or proceedings relating to this Guarantee ("Proceedings"), each party:

(i) submits to the exclusive jurisdiction of the English courts; and

(ii) waives any objection it may have at any time to the laying venue of any Proceedings brought in any such court, waives any claim that such Proceedings have been brought in an inconvenient forum, and further waives the right to object, with respect to any such Proceedings, that such court does not have any jurisdiction over such party.

---

## EXECUTION

**IN WITNESS WHEREOF** this Guarantee has been executed and delivered as a deed by the Guarantor on the date first before written.

**SIGNED** by
and
and thereby executed by
**HSBC PLC**
as its Deed

Agreed and acknowledged by

By:
Name:
Title:

---

Agreed and acknowledged by
**The Noteholders**

By: [etc]

---

## EXECUTION

**SIGNED** as a deed by
Director and by
Director/Secretary
duly authorised for and on behalf of
