CMO Tactical Action Plan - First 10 Days

Joshua, Chief Marketing Officer
Date: 15 December 2025

CLASSIFICATION OF DECISIONS

Tactical (No Board Approval Required): Less than 50,000 GBP investment, less than 1 month to implement
Strategic (Board Approval Required): Greater than 50,000 GBP or longer than 1 month

CRITICAL CONTEXT FOR CMO

The company loses customers representing greater than 20% of revenues triggers Event of Default on the 10M GBP seller note, which cascades to personal guarantee against all five management team members.
Source: Loan_Note_Instrument.md line 537

Current customer concentration:
UK 23%, Germany 16%, USA 12%, France 8% (Decathlon TERMINATING), Central Europe 6%
Losing UK alone triggers default. Losing Germany plus France triggers default.
Source: 01-Due-Diligence-nd.md lines 362-378

FIVE OPERATIONAL ACTIONS FOR FIRST 10 DAYS

ACTION 1: Customer Revenue Risk Audit (Days 1-3)
Classification: Tactical
Cost: 0 GBP (internal data request)
Time: 3 days
Owner: CMO with CFO support

What: Request complete customer list with trailing 12-month revenue by account. Map which customer combinations exceed 20% threshold.

Why: The 20% customer loss default trigger is existential. Must know exactly which accounts, if lost, would trigger personal guarantee cascade.

Deliverable: Risk matrix showing customer combinations that trigger default. Priority retention list.

Source: Loan_Note_Instrument.md line 537 (20% trigger), 01-Due-Diligence-nd.md lines 16-19 (customer dependence warning)

Specific data needed:
- Top 20 customers by revenue
- Contract expiration dates
- Credit terms
- Relationship owner
- Last QBR date


ACTION 2: Halfords Emergency Meeting (Days 1-5)
Classification: Tactical
Cost: Approximately 500 GBP (travel to Halfords HQ)
Time: Schedule within 5 days, meeting within 10 days
Owner: CMO with CEO support

What: Schedule urgent meeting with Halfords procurement. Their contract expired Mar CY and they are demanding extended credit from 90 to 150 days.

Why: Halfords is 9% of UK sales. UK is 23% of total revenue. Losing Halfords alone does not trigger 20% default but losing Halfords plus any other major UK account would. Must stabilize relationship immediately.

Deliverable: Meeting scheduled. Understanding of their requirements. Counter-proposal prepared.

Source: Disclosure_Letter_2025.md line 97 (150 day credit demand), 01-Due-Diligence-nd.md line 407 (9% of UK), line 446 (contract details)

Preparation needed:
- Halfords account history
- Their competitive alternatives
- Our margin on Halfords business
- Maximum credit extension we can offer
- What we need in return (volume commitment, longer contract)


ACTION 3: Bas and Hannah Relationship Assessment (Days 2-4)
Classification: Tactical
Cost: 0 GBP (internal meetings)
Time: 2-4 days
Owner: CMO

What: Separate one-on-one meetings with Barry "Bas" West and Hannah (Head of Sales) to understand the tension between them and assess flight risk.

Why: Bas is responsible for 60% of company sales volume (30M GBP). He has been at Maywood 32 years. There is documented tension with his boss Hannah. Losing Bas could devastate sales and trigger 20% customer loss through relationship damage.

Deliverable: Assessment of relationship dynamics. Retention risk level for both. Recommended interventions.

Source: work_journal.md lines 65-71 (Bas profile, tension), lines 52 (Hannah profile)

Meeting agenda for Bas:
- Career aspirations
- Relationship with key accounts
- View on company direction
- Concerns about new ownership
- What would make him stay

Meeting agenda for Hannah:
- Team dynamics
- View on Bas performance
- Sales strategy vision
- Resource needs
- What does she need from CMO


ACTION 4: Online Channel Contract Review (Days 5-8)
Classification: Tactical
Cost: 0 to 5,000 GBP (internal review or legal review)
Time: 4-5 days
Owner: CMO with Legal support

What: Review Wiggle and Chain Reactions contracts before Dec CY expiration. Both contracts state "Chain Reactions to cover online marketing costs" which needs verification.

Why: Online is only 5% of sales but is the fastest-growing channel at 13.55% CAGR globally. These contracts expire Dec CY. Must renew and expand, not let lapse.

Deliverable: Contract summary. Renewal recommendation. Negotiation strategy for expanded terms.

Source: 01-Due-Diligence-nd.md lines 448-449 (contract terms), lines 409-410 (2% and 3% of sales), Mordor Intelligence (13.55% online CAGR)

Questions to answer:
- Are they actually covering marketing costs as contracted?
- What is our margin on online sales vs retail?
- Can we negotiate better terms or expanded volume?
- Should we explore D2C capability?


ACTION 5: Top 10 Customer Introduction Calls (Days 3-10)
Classification: Tactical
Cost: 1,000 to 2,000 GBP (calls, potential travel)
Time: 7 days
Owner: CMO

What: Personal introduction calls to top 10 accounts (by revenue) to introduce new management, assess relationship health, and signal continuity.

Why: DD report explicitly recommends "Given the reliance on key customers, your management may wish to meet with them to discuss the implication of the deal prior to the sale." This was not done. Must do immediately post-close.

Deliverable: Relationship health scorecard for top 10 accounts. Any immediate concerns flagged. Follow-up meeting schedule.

Source: 01-Due-Diligence-nd.md line 79 (recommendation), lines 392-410 (main retailers)

Top 10 priority list (based on concentration):
1. Zweirad-Stadler Germany, 14% of Germany sales
2. Evans Cycles UK, 11% of UK sales, EXCLUSIVITY clause
3. Cycle Surgery UK, 11% of UK sales
4. REI USA, 28% of US sales
5. Halfords UK, 9% of UK sales, CONTRACT EXPIRED
6. InterS Italy, 18% of Italy sales
7. Bike Totaal Netherlands, 9% of NL sales
8. Biretco Netherlands, 7% of NL sales
9. Intersport France, 6% of France sales
10. Go-Sport France, 3% of France sales

Note: Decathlon France excluded as they are terminating (Disclosure_Letter_2025.md line 105)


SUMMARY TABLE: FIRST 10 DAYS

Day 1-3: Customer Revenue Risk Audit, 0 GBP, Tactical
Day 1-5: Halfords Emergency Meeting scheduled, 500 GBP, Tactical
Day 2-4: Bas and Hannah Meetings, 0 GBP, Tactical
Day 3-10: Top 10 Customer Calls, 1,500 GBP, Tactical
Day 5-8: Online Contract Review, 2,500 GBP, Tactical

Total estimated spend: 4,500 GBP
All actions under 50,000 GBP threshold and under 1 month
No board approval required


ITEMS REQUIRING BOARD APPROVAL (For Later Discussion)

These exceed 50,000 GBP or 1 month implementation:

1. CYLO X E-bike Launch: Development and launch costs unknown but likely 200,000+ GBP. E-bikes are 51% of global market at 12.76% CAGR. Source: Mordor Intelligence, work_journal.md line 141

2. Online Channel Investment: Building D2C capability would exceed 50,000 GBP. Online is fastest-growing channel at 13.55% CAGR. Source: Mordor Intelligence

3. Asia-Pacific Market Entry: We have 1% exposure to 48% of global market. Any meaningful entry would require significant investment. Source: Mordor Intelligence, 01-Due-Diligence-nd.md line 378

4. Tour de France Sponsorship Review: Current spend unknown but likely significant. 150M EU viewers, 15M social followers, 1.3B video views justifies continued investment. Source: Statista

5. Product Modernization: Cantilever brakes to disc brakes transition. Manufacturing investment required. Source: work_journal.md line 78


5-YEAR STRATEGY FRAMEWORK (For End of 100 Days Discussion)

The board has requested a 5-year strategy discussion covering six dimensions. CMO perspective on each:

Dimension 1: Market Position
Current: Mid-sized UK assembler, 150-year heritage brand, Tour de France sponsor
5-Year Vision: Top 3 in UK market, meaningful presence in e-bikes, expanded online

Dimension 2: Product Portfolio
Current: Race 8%, Road 33%, MTB 29%, City 9%, Children 20%. No e-bikes.
5-Year Vision: E-bikes 20%+ of portfolio, children's growth captured, race premium maintained

Dimension 3: Geographic Footprint
Current: UK 23%, Germany 16%, USA 12%, Asia 1%
5-Year Vision: Asia-Pacific 5-10%, Central Europe 10%, maintain core markets

Dimension 4: Channel Mix
Current: Offline 95%, Online 5%
5-Year Vision: Online 20%, D2C capability established

Dimension 5: Customer Relationships
Current: Heavy reliance on few large accounts, 20% loss triggers default
5-Year Vision: No single customer greater than 10%, diversified base, long-term contracts

Dimension 6: Brand and Marketing
Current: Heritage brand, Tour de France association, limited digital presence
5-Year Vision: Digital-first marketing, sustainability positioning aligned with DratLink ESG goals

Note: Full 5-year strategy to be developed with C-suite team and presented to board at end of first 100 days.


RISK REGISTER FOR CMO FUNCTION

Risk 1: Customer concentration default trigger
Likelihood: Medium
Impact: Critical (personal guarantee)
Mitigation: Actions 1 and 5 above

Risk 2: Bas departure
Likelihood: Medium (tension with Hannah)
Impact: High (60% of sales)
Mitigation: Action 3 above

Risk 3: Halfords contract loss
Likelihood: Medium (demanding extended credit)
Impact: Medium (9% UK, 2% total)
Mitigation: Action 2 above

Risk 4: Online channel contracts lapse
Likelihood: Low (expiring Dec CY)
Impact: Low-Medium (5% of sales but fastest-growing)
Mitigation: Action 4 above

Risk 5: Decathlon termination impact
Likelihood: Certain (6 months notice given)
Impact: Low (1% of France, less than 0.5% total)
Mitigation: Redirect resources to other French accounts


CMO Joshua
15 December 2025