# Your First Hundred Days - Course Overview

**Course:** GEMBA26_EFE_Your First Hundred Days
**Code:** EMBA-2600-EFE

---

## Introduction

The INSEAD YFCD Capstone is an integrative, immersive, and inspirational learning experience that is part of the core curriculum.

As part of this unique course, you will become the C-Suite Executives of a small & medium sized company in the bicycle industry.

Through a dedicated AI powered chat simulation platform, role plays, team and individual assignments, you will take on a series of tough business & sustainability challenges that you will need to resolve as a team by combining your analytical & behavioural skills, as well as embodying an entrepreneurial spirit.

You and your team will begin by negotiating the acquisition of Maywood Cycles, a long-standing British bicycle manufacturer. Once the deal is secured, you will take over as the new leadership team and run the company through its first 100 days, addressing real-world challenges and engaging with key stakeholders including investors, bankers, customers, suppliers, employees, local officials and the media. The experience culminates in the development and presentation of a five-year business and sustainability strategy plan that integrates performance with progress.

---

## Course and Learning Objectives

The main goal of this course is to provide you with an experience of being a business leader who will face and need to resolve business & sustainability challenges & opportunities. In particular this course will provide you with the chance to:

- Integrate your knowledge and experience to deal with general management challenges across business & sustainability objectives
- Sharpen your ability to work as a management team, dividing work and coordinating your contributions as you face a stream of information and decisions
- Reflect upon your own management style, strengths, and weaknesses as you adapt and learn in a fast-paced environment
- Enhance your skills at communicating within and across teams, and when dealing with employees and external stakeholders, role-played by alumni and veteran entrepreneurs
- Develop an entrepreneurial mindset that applies across career paths, whether you pursue consulting, banking, industry, corporate innovation, or your own startup, equipping you to think creatively, act under uncertainty, and drive impact in any professional context

---

## Specific Course Rules

- This is a Core Course part of your Degree Program so is mandatory
- It is a three day long experiential course mixing a web application, teamwork and role plays with people from your class or external volunteers (mostly INSEAD Alumni) and will require your full attention
- On top of completing the assignments, this being an experiential course, your presence is required for all the scheduled hours - it is not possible to miss a session and catch-up as the course is live with events unfolding in real-time (exceptions are made for medical and family emergencies but will require verification)
- The general policies outlined in the MBA Code of Conduct (Academic Norms) apply

---

## Course Materials

The course lasts three days, broken up into six half-day moments with the following broad format:

1. All hands kick-off session at the start of each day (the first one on the first day is longer than the others to provide important information for the launch of the course)
2. Then the three days are broken up into continuous segments with the following broad structure:
   - Response to messages sent by the LiveCase web application providing you with instructions, information, and context for you to complete the main assignment and role play for that half-day
   - Teamwork to (a) complete the main assignment and (b) prepare your role play
   - Role play certain situations and get feedback
   - Complete your main assignment and get feedback
3. Every day ends with a debrief

---

## Grading Scheme

The capstone course is graded on a **pass/fail** basis. Performance will be evaluated as:

| Weight | Component | Evaluation Level |
|--------|-----------|------------------|
| 20% | Individual completion of the LiveCase series | Individual |
| 20% | Class participation | Individual |
| 30% | Graded exercises (analyses/reports) | Team |
| 30% | Performance as evaluated by role players | Team |

However, to enhance engagement, we will introduce a form of friendly competition, the details of which will be explained to you by your section Lecturer. Essentially teams accumulate points based on their actions in response to events - across several different categories. Accumulated points result in an overall team ladder to determine a podium of Bronze, Silver and Gold winners.

---

## What to Expect in This Course?

It is an intense course with a lot of information and activities where you will need to be your own guide to understand what you think are the objectives of the business you are running, what you think should be done and how.

### How to Approach the Course

The Capstone is not your typical course as you will be immersed into a mixed reality learning experience where you will be in charge.

You will receive a constant stream of messages from the LiveCase web application from various stakeholders providing you with instructions, information and context to help you complete your main assignments and role plays.

The assignments and role plays in turn will help you craft a 5 year cross-functional strategy over the course of the first two days that you will present on your third day to the Board and other key stakeholders.

Throughout, you will be guided by section Lecturers who are INSEAD Alumni veteran executives who will help you bridge the gap between the theory and the practice across all academic areas. This is to best prepare you for the career you will have after graduation.

You will take an active part in defining your individual and team roles and responsibilities. You will need to make sense of the situations you will be presented with and deal with a certain level of vertigo as no one will explicitly tell you how to complete your work. As in the real world, leaders need to craft the vision, the mission and the strategy - then execute.

The Capstone is a complex experiential LiveCase where you will live in the first person as a team, processing information, carrying out strategic analyses to make recommendations, and interacting with other teams and with external role players who represent different types of employees and stakeholders.

You will be provided with access to the LiveCase web application that will act as your main communication and dashboard application. There, you will communicate with virtual characters that immerse you into the scenario. However, this is not a computer simulation. Decisions have an impact on organizational performance but the course is designed to be open ended such that you can create the path and make the business & sustainability choices you want to make. The objective is to integrate analytical and behavioral skills into a holistic experience.

### In Summary

The Capstone emphasizes learning by doing. You will:

- Encounter a variety of business & sustainability challenges based on realistic experiences grounded in practice
- Apply your academic learnings across your core and elective courses at INSEAD by performing a number of analyses that lead to recommendations you must present either as decisions, analyses, or as interactive briefings with role players
- Receive debrief sessions, individual & team feedback, and learn through reflection on how you approached the stream of challenges you faced, what worked

---

## Meet the Professors

### Antoine (Tony) Duvauchelle

Antoine (Tony) Duvauchelle is an Adjunct Professor at INSEAD. He teaches strategy, innovation, and leadership for executive and degree programmes. Previously, he was an Entrepreneur in Residence for Project A Ventures, a leading internet VC company in Europe, where he led the international business development of Tirendo, an innovative e-commerce company (acquired for 50mEUR). He was before this an associate at Good Energies, a leading 2bnEUR global PE/VC clean energy technologies investment firm.

Antoine was also a Senior Consultant for Frontier Economics Ltd., a boutique economics consultancy in London where he advised European utility companies, institutional banks, and large corporations on questions of strategy, regulation, and anti-trust. He holds an MBA from INSEAD, a master's degree in international politics and economics from Johns Hopkins University, and bachelor's degree in politics, philosophy, and economics from the University of Maryland. Antoine was once an Ironman triathlete.

### Ash Singh

Ash is a Lecturer and coach at INSEAD. He runs a startup accelerator program that launched 100s of startups in over 50 countries. Ash's entrepreneurial journey started while still a student at Chinese University in Hong Kong, he conceived and launched SNBS, a corporate social networking company which was acquired when he was just 22 years old.

In his next role, Ash served as the Chief Technology Officer for At-Life, which created Singapore's largest customer loyalty rewards program with 500,000 members, for McDonald's in all of their 125 restaurants. Ash was also one of founders of Interactive SG - which flourished into one of Asia's leading digital media and new business accelerator based in Singapore. His flagship project "The Angel's Gate" was Asia's first crowdfunding TV platform for entrepreneurs that was aired prime-time on MediaCorp's Channel NewsAsia to 30MM homes in the region. As a basketball fan, he is a co-owner and "super fan" of the Singapore Slingers professional basketball team.

### Adrian Johnson

Adrian Johnson is an Adjunct Professor of Entrepreneurship at INSEAD, where he has run start-up bootcamps, teaches the legendary "Your First Hundred Days" MBA/EMBA course, developed interactive, immersive "live case" experiential learning workshops and taught and directed Executive Education Programmes focussing on innovation, disruption and digital transformation. He has co-founded several media and technology companies, holds an Engineering degree from Imperial College London and an MBA from INSEAD.

### Tori Fahey

Tori Fahey is a Lecturer of Entrepreneurship at INSEAD. She is an entrepreneur, an investor, and a passionate finance specialist. Most recently, she started a company focused on developing innovative products for cyclists which has become one of the largest in its segment. She devoted the first decade of my career to finance, focusing on private equity and venture capital.

She pursued opportunities to explore other interests and combine them with this experience, balancing time between learning, consulting, investing, and exploring the world on two wheels. She studied business and public policy. She consulted for government agencies, IOs and NGOs. She invested in a range of projects and start-ups, with a particular focus on social impact. She cycled across continents, discovering new places, people and ways of doing things. She has diplomas from the University of Calgary, INSEAD, Columbian and Sciences Po.
