![alt text](image.png)




## Transcription

**To: Maywood Senior Leadership**

**OFFICIAL NOTIFICATION re: accident in Maywood House**

Gideon Benson was working in chain installation in Road and Race.

This is not his usual post as he should be working in nuts and bolts in Road and Race. He has no training on the chain installation machines.

The machine that automatically threads the chain onto the toothed chain ring jammed. Gideon, having no training on this machine, did not ensure that the machine was safety stopped before he put his hand between the chain ring and the chain in an attempt to unjam it. Unfortunately the machine started up again and his hand was caught between the chain and the sharp teeth of the chain ring. We don't have a complete medical report at this time but witnesses agree that several fingers on his left hand have been severed.

Fortunately a few of the lads and lasses on the floor are trained in first aid, so they were able to stem the bleeding and to collect the severed finger(s).

Someone called emergency services. A helicopter showed up, along with two ambulances, a fire engine and the police.




---

## Crisis Communication Research Summary

**Source:** https://intheknow.insead.edu/blog/communications-times-crisis

---

### Summary: INSEAD Framework for Crisis Communication

**Primary Objective:** Minimise disruption to the organisation's capability to service clients and minimise dissent between the organisation and its stakeholders.

**Four Essential Communication Criteria:**

| Criterion | What It Means | Why It Matters |
|-----------|---------------|----------------|
| **Quick** | Address changing situations promptly | Delays create information vacuums |
| **Clear** | Specific timelines, not vague commitments | Ambiguity breeds anxiety and rumors |
| **Frequent** | Regular updates showing ongoing action | Demonstrates leadership is engaged |
| **Empathetic** | Acknowledge shared burden | Avoid "us vs them" messaging |

**Recommended Structure:** Establish parallel task forces - one representing leadership, one representing stakeholders (employees) - to enable efficient feedback collection and rapid decision communication.

**Critical Mistakes to Avoid:**
- Delaying task force formation
- Using inappropriate humor
- Spreading panic through emotional language
- Ignoring information provided by stakeholders

---

### ACTION PLAN: Gideon Benson Workplace Injury

#### IMMEDIATE (Next 2 Hours)

| Action | Owner | Criterion Met |
|--------|-------|---------------|
| 1. Confirm Gideon's medical status and hospital location | COO (Jessica) | Quick |
| 2. Notify Gideon's emergency contact/family | CHRO (Liza) | Quick, Empathetic |
| 3. Issue holding statement to floor staff (verbal) | Plant Manager (John Stephens) | Quick, Clear |
| 4. Secure the chain installation machine - DO NOT OPERATE | COO (Jessica) | Quick |
| 5. Identify and interview witnesses | CHRO (Liza) | Quick |

#### SHORT-TERM (Next 24 Hours)

| Action | Owner | Criterion Met |
|--------|-------|---------------|
| 6. Form Employee Task Force (2-3 floor reps) | CHRO (Liza) | Structure |
| 7. Form Leadership Task Force (CEO, COO, CHRO) | CEO (Tommy) | Structure |
| 8. Prepare written statement for all employees | CMO (Joshua) | Clear |
| 9. Brief the Board/DratLink on incident | CEO (Tommy) | Quick |
| 10. Contact HSE (Health & Safety Executive) proactively | COO (Jessica) | Quick |
| 11. Review training records - who authorized Gideon at that station? | CHRO (Liza) | Clear |
| 12. Document timeline of events with witness statements | CHRO (Liza) | Clear |

#### KEY MESSAGES (For All Communications)

**What We Know:**
- Gideon Benson was injured today at approximately [TIME]
- He received immediate first aid from trained colleagues
- Emergency services responded and he is receiving medical care
- The machine involved has been secured and taken out of operation

**What We Are Doing:**
- Our first priority is Gideon's wellbeing and supporting his family
- We are conducting a full investigation into how this happened
- We are reviewing all training and safety protocols
- We will share findings and any policy changes with all staff

**What We Don't Know Yet:**
- Full extent of Gideon's injuries (awaiting medical report)
- Root cause of why he was at an unauthorized station
- Whether equipment malfunction contributed

**Tone Guidance:**
- Lead with concern for Gideon, not corporate liability
- Acknowledge this affects everyone - "We are all shaken by this"
- Do NOT assign blame publicly until investigation complete
- Do NOT speculate on outcomes

#### STAKEHOLDER COMMUNICATION MATRIX

| Stakeholder | When | Channel | Key Message |
|-------------|------|---------|-------------|
| Floor employees | Immediate | Verbal briefing | Facts, reassurance, investigation underway |
| All Maywood staff | Within 4 hours | Email/notice | Written statement |
| Gideon's family | Immediate | Phone/in-person | Support, information, point of contact |
| Board/DratLink | Within 4 hours | Call | Incident summary, response plan |
| HSE | Within 24 hours | Formal notification | Compliance reporting |
| Media (if contacted) | Reactive only | Prepared statement | Brief facts, focus on response |
| Customers | Only if asked | Account manager | Reassurance, no service impact |

#### UPDATE SCHEDULE (Frequent Communication)

- **Hour 0-4:** Verbal updates to floor every hour
- **Day 1:** Written update to all staff end of day
- **Day 2-3:** Daily email updates on investigation progress
- **Week 1:** Full staff meeting to share preliminary findings
- **Ongoing:** Weekly summary until resolution

---

### APPENDIX: Full Article Text

**Communications in Times of Crisis**
*INSEAD In The Know Blog*
*Published: February 13, 2023*
*Author: Christian Wirawan, INSEAD MBA Candidate*

Christian Wirawan is an INSEAD MBA candidate from Indonesia with expertise in tech, startups, and management consulting who advocates for diversity and inclusion initiatives.

**Core Framework:**

The primary objective of crisis communication is to "minimise disruption to the organisation's capability to service clients and minimise dissent between the organisation and its stakeholders."

**Four Essential Communication Criteria:**

1. **Quick Response** - Address changing situations promptly, such as government announcements or breaking developments. Speed prevents information vacuums that get filled with rumors.

2. **Clear Messaging** - Minimize ambiguity by providing specific timelines rather than vague commitments. Instead of "we'll update you soon," say "we will provide an update by 5pm today."

3. **Frequent Updates** - Demonstrate ongoing action through regular communications, including weekly summaries of decisions and discussions. Even "no new information" is an update.

4. **Empathetic Tone** - Acknowledge shared burden; avoid messaging suggesting only leadership faces challenges. Use "we" language and recognize the impact on all stakeholders.

**Organizational Structure Recommendation:**

Establish parallel task forces:
- One representing the organization's leadership
- One representing stakeholders (employees, customers, etc.)

This structure enables:
- Efficient feedback collection and collation
- Clear communication channels between parties
- Rapid decision announcement and implementation
- Two-way dialogue rather than top-down broadcasting

**Critical Mistakes to Avoid:**

- Delaying task force formation - act immediately
- Using inappropriate humor in serious contexts
- Spreading panic through emotional language
- Ignoring information provided by stakeholders
- Over-promising and under-delivering
- Going silent during periods of uncertainty

**Source URL:** https://intheknow.insead.edu/blog/communications-times-crisis 