# Bicycle Market Intelligence - December 2025

**Sources:**
- Mordor Intelligence: https://www.mordorintelligence.com/industry-reports/bicycle-market
- Statista: https://www.statista.com/topics/1686/cycling/#topicOverview

---

## Global Market Size & Growth

| Metric | Value | Source |
|--------|-------|--------|
| 2025 Market Value | **USD 83.5 billion** | Mordor Intelligence |
| 2030 Projected Value | **USD 137.82 billion** | Mordor Intelligence |
| CAGR (2025-2030) | **10.54%** | Mordor Intelligence |
| Alternative estimate | USD 60B (2025) → USD 70B (2029) | Statista |

---

## Segment Analysis

### By Product Type (Global 2024)

| Segment | Market Share | CAGR to 2030 | Insight |
|---------|--------------|--------------|---------|
| **E-Bicycles** | **51.25%** | **12.76%** | DOMINANT and fastest-growing product |
| Regular Bikes | 85.78% of design | - | Traditional segment |
| Folding Bikes | - | 11.43% | Niche but growing |

### By End-User (Global 2024)

| Segment | Market Share | CAGR to 2030 | Insight |
|---------|--------------|--------------|---------|
| Men | 46.23% | - | Largest segment |
| Women | Growing | - | Emerging opportunity |
| **Children** | - | **10.61%** | **FASTEST-GROWING end-user segment** |

### By Distribution Channel (Global 2024)

| Channel | Revenue Share | CAGR to 2030 | Insight |
|---------|---------------|--------------|---------|
| Offline Retail | 81.23% | - | Still dominant |
| **Online Retail** | - | **13.55%** | **FASTEST-GROWING channel** |

---

## Regional Analysis

### Global Market Share (2024)

| Region | Share | CAGR to 2030 | Status |
|--------|-------|--------------|--------|
| **Asia-Pacific** | **48.11%** | **13.33%** | Largest & fastest-growing |
| Europe | ~25% | ~5% | Mature, declining units |
| North America | ~15% | ~7% | Growing steadily |
| Rest of World | ~12% | Varies | Emerging |

### European Union Specifics

| Metric | Value | Trend |
|--------|-------|-------|
| Units sold 2024 | 16.2 million | DOWN from 17M in 2023 |
| Units forecast 2029 | 16.2 million | FLAT |
| E-bike share of sales | **25%+** | UP from 18% in 2019 |
| Germany e-bike sales | 2.1 million units | Market leader |

### United Kingdom Specifics

| Metric | Value | Source |
|--------|-------|--------|
| Regular cycling participants | 7.2 million | Statista |
| Household bicycle spending | £1.6 billion (2023) | Statista |
| Average new bicycle price | **£600** (2024) | Statista |
| Population cycling regularly | 16% (age 16+) | Statista |

### United States Specifics

| Metric | Value | Source |
|--------|-------|--------|
| Market value 2023 | USD 9.2 billion | Statista |
| Forecast 2029 | USD 10.3 billion | Statista |
| Cycling participants 2024 | 56+ million | Statista |
| Road cycling participants | 42.5 million | Statista |
| Mountain biking | 9.24 million | Statista |

---

## Key Growth Drivers (Ranked by CAGR Impact)

| Driver | CAGR Impact | Relevance to Maywood |
|--------|-------------|----------------------|
| Government support for eco-transport | +2.7% | City bike contracts, soft loans |
| Urban congestion/commuting | +2.1% | City bikes, e-bikes |
| Environmental awareness | +1.9% | Brand positioning, ESG |
| Fitness trends | +1.8% | Road bikes, race bikes |
| Workplace wellness programs | +0.8% | Corporate sales channel |
| Rising fuel prices | +0.6% | All segments benefit |

## Key Market Restraints

| Restraint | CAGR Impact | Relevance to Maywood |
|-----------|-------------|----------------------|
| High e-bike costs | -1.8% | CYLO X pricing strategy |
| Substitute transport | -1.4% | Urban competition |
| Poor rural roads | -0.8% | MTB opportunity |
| Counterfeits | -0.4% | Brand protection |

---

## Competitive Landscape

### Major Global Players (by revenue)

1. Accell Group NV
2. Trek Bicycle Corporation
3. Pon Holdings BV
4. Giant Manufacturing Co. Ltd
5. Specialized Bicycle Components Inc.
6. Shimano Inc.
7. Scott Sports SA
8. Merida Industry Co. Ltd

### Maywood Position
- Mid-sized UK assembler
- 150-year heritage brand
- Not in global top 10
- Niche position in race bikes (Tour de France)

---

## Key Trends Affecting Strategy

### 1. E-Bike Dominance
- **51.25% of market** and growing at 12.76% CAGR
- Europe: 25%+ of sales now e-bikes
- Battery technology improving, costs declining
- **Maywood implication:** CYLO X launch is CRITICAL

### 2. Children's Segment Growth
- **10.61% CAGR** - fastest-growing end-user segment
- Contradicts assumption that children's is "low quality, low margin"
- **Maywood implication:** Reconsider phase-down strategy

### 3. Online Channel Explosion
- **13.55% CAGR** - fastest-growing channel
- Current Maywood online: ~5% (Wiggle, Chain Reactions)
- **Maywood implication:** Significant underinvestment in online

### 4. European Unit Decline
- EU units: 17M (2023) → 16.2M (2024) → flat to 2029
- Value growing but units flat/declining
- **Maywood implication:** Must capture value (premiumization) not just volume

### 5. Asia-Pacific Dominance
- 48% of global market, 13.33% CAGR
- Maywood has only 1% Asia sales
- **Maywood implication:** Major geographic gap

### 6. Tour de France Value
- 150 million European viewers
- 15 million social followers, 1.3B video views
- **Maywood implication:** Sponsorship ROI potentially very high

---

## Strategic Implications for Maywood

### REVISED Priorities Based on Market Data

| Previous Recommendation | Market Data Says | Revised View |
|------------------------|------------------|--------------|
| Phase down children's bikes | Children's = fastest-growing segment (10.61% CAGR) | **RECONSIDER** - may be growth opportunity |
| Focus on road/race | Road cycling = 42.5M US participants | **CONFIRMED** - strong market |
| Expand Central Europe | EU units declining, but value growing | **CONFIRMED** - but focus on premium |
| Avoid Spain/Italy | No contradicting data | **CONFIRMED** |
| Limited online focus | Online = 13.55% CAGR (fastest channel) | **CHANGE** - must grow online |
| No mention of e-bikes | E-bikes = 51% of market, 12.76% CAGR | **CRITICAL GAP** - CYLO X is essential |
| No Asia strategy | Asia = 48% of market, 13.33% CAGR | **MAJOR GAP** - need entry strategy |

---

*Document created: 15 December 2025*
*Next review: Quarterly market update*
