# First Hundred Days - Executive Reflections

**Team:** KPOP Unicorn Hunters
**Company:** Maywood Cycles Ltd
**Date:** 15 December 2025

---

## WHO WE ARE

We are the incoming C-Suite management team of Maywood Cycles Ltd:

| Role | Name | Primary Responsibilities |
|------|------|-------------------------|
| **CEO** | Tommy | Strategy, PE relationship, Board, external stakeholders |
| **COO** | Jessica | Operations, supply chain, production, SAP implementation |
| **CMO** | Joshua | Sales, marketing, customer retention, brand |
| **CHRO** | Liza | People, culture, HR policies, union relations |
| **CFO** | Ali | Finance, treasury, cash flow, lender relationships |

**Our situation:** We have acquired Maywood Cycles with £10M equity from DratLink Capital (PE) and a £10M seller's note guaranteed by HSBC. We now own and operate the company. Our first board meeting is in February.

---

# PRIORITY INSIGHTS

## 1. SELLER NEGOTIATION LEVERAGE

**The £2M Gap:** Deal price is £22M but book value is £20M. We need to either raise the balance sheet by £2M or reduce the purchase price by £2M.

### Why Sellers Are Motivated to Reduce Price

| Motivation | Detail | Leverage |
|------------|--------|----------|
| **Their Own Disclosed Problems** | Decathlon terminating orders, Halfords demanding extended credit | Material adverse changes = grounds for price reduction |
| **Seller's Note Risk** | They're taking £10M over 4 years. If we fail, they don't get paid | Lower price = smaller note = better chance of payment |
| **They Created the Liabilities** | £2.2M pension deficit (deferred) | Should clear their mess or accept price reduction |
| **Speed & Certainty** | 150-year family business, ready to exit | If this deal falls through, how long to find another buyer? |
| **No Competing Offers** (likely) | Cannondale's offer is shaky (financial problems, management changes) | Weak negotiating position |
| **Clean Exit** | Reps & Warranties exposure (€1M) post-sale | Lower price now = less likely warranty claims later |

**Sources:** `Disclosure_Letter_2025.md`, `Loan_Note_Instrument.md`, `work_journal.md:158-163`

### Quantified Negotiation Points

| Item | Value | Source |
|------|-------|--------|
| Director loans | ~~£1,000,000~~ PAID IN SALE | `01-Due-Diligence-nd.md` |
| Pension provisions (they created) | £2,200,000 | `01-Due-Diligence-nd.md` |
| Deferred tax shortfall | £350,000 | `Disclosure_Letter_2025.md` |
| HP default | £40,000 | `Disclosure_Letter_2025.md` |
| Known CapEx needs | £165,000 | `01-Due-Diligence-nd.md` |
| **TOTAL LEVERAGE** | **£4,270,000** | More than enough to close £2M gap |

---

## 2. CITY BIKE CONTRACT OPPORTUNITY

**Source:** `work_journal.md:143`
> "City council is offering a sharing program - 1000 CYLO bikes for free in city, terms to be negotiated. Soft loan with job creation requirements."

### Financial Analysis (1,000 bikes)

| Pricing Scenario | Revenue | COGS (£110/unit) | **Net Margin** |
|------------------|---------|------------------|----------------|
| At MSRP (£399) | £399,000 | £110,000 | **£289,000 (72%)** |
| At Retailer (£249) | £249,000 | £110,000 | **£139,000 (56%)** |
| At Wholesale (£147) | £147,000 | £110,000 | **£37,000 (25%)** |

**Source:** `01-Due-Diligence-nd.md:262-263` (City bike COGS = £110, pricing tiers)

### Deal Structure
- **Soft loan** - Government-backed, below-market interest rates
- **Job creation requirements** - Condition for favorable financing (protects against layoffs)

### Strategic Value Beyond Margin
- **Volume boost**: 1,000 units = ~6% increase in city bike production
- **Free advertising**: CYLO-branded bikes visible across the city
- **Government relationship**: Opens door for future municipal contracts
- **Soft loan benefit**: Favorable financing helps cash position

**CMO Priority (Joshua):** Negotiate pricing between retailer and MSRP, secure branding rights on all bikes, define job creation thresholds we can meet.

---

## EXECUTIVE SUMMARY

This is our working document as the management team. It contains:

1. **Scenario Planning** - What we need to present to the board
2. **Our Personal Exposure** - What we've personally guaranteed
3. **Financial Position** - What we inherited
4. **Operational Priorities** - What we need to execute
5. **Risk Management** - What could go wrong and how we prevent it

**Our #1 Priority:** Make the June Year 1 loan redemption of £3M while retaining all major customers.

---

# OUR FIRST 100 DAYS: SCENARIO PLANNING

*This is what we bring to the February board meeting.*

---

## WHAT THE BOARD EXPECTS FROM US

> "The company will prepare an action plan and monthly targets by the time of the first board meeting in February this year."
> — Term Sheet, Section VII.F

### Our Board Composition

| Seat | Representative | Their Interest | Our Approach |
|------|----------------|----------------|--------------|
| 1 | DratLink Partner | ROI, growth | Show path to 10-15% CAGR |
| 2 | DratLink Partner | ESG, governance | Sustainability roadmap |
| 3 | DratLink Partner | Operations, risk | Risk mitigation plan |
| 4 | Tommy (CEO) | Execution | Lead the narrative |
| 5 | TBD (Management) | Functional | Support with data |

**Reality:** DratLink controls 3-2. We need their buy-in on everything.

---

## OUR CRITICAL FIRST 6 MONTHS: THE CASH PROBLEM

### The June Year 1 Challenge

We need to make our first loan redemption payment of **£3M by 20 June**. Here's our cash reality:

| Cash Requirement | Amount | Timing |
|------------------|--------|--------|
| Loan Note Redemption | £3,000,000 | 20 June Year 1 |
| Q1 Interest Payment | ~£100,000 | 31 January |
| Q2 Interest Payment | ~£100,000 | 30 April |
| Director Loan Repayment | ~~£1,000,000~~ PAID IN SALE | At closing |
| **Total Cash Needed** | **~£3,200,000** | First 6 months |

### What Cash We Have

| Source | Amount | Notes |
|--------|--------|-------|
| Operating Cash Flow (6 mo) | ~£820,000 | Based on £1.64M annual |
| Cash on Hand | £175,000 | Per CY-1 balance sheet |
| Invoice Discounting | Variable | Already being used |
| **Subtotal Available** | **~£1,000,000** | |
| **GAP TO FILL** | **~£2,200,000** | Director loans paid in sale |

### Our Options to Fill the Gap

| Option | Amount | Owner | Feasibility | Downside |
|--------|--------|-------|-------------|----------|
| Sell Victoria House | £3,000,000 | CFO | Medium | Lose expansion capacity |
| Additional PE injection | Variable | CEO | Low | Dilutes us further |
| Bank facility increase | £1-2M | CFO | Medium | More covenants |
| Aggressive AR collection | Variable | CFO | Medium | May strain customers |
| Delay non-critical CapEx | £115,000 | COO | Easy | Risk operational issues |

**Our recommendation to the Board:** Sell Victoria House or negotiate bank facility increase. We cannot miss the June payment.

---

## OUR FOUR SCENARIOS

We've modeled four scenarios for Year 1. This is what we present to the Board.

### Scenario Overview

| Scenario | Revenue | EBITDA | Personal Guarantee Risk |
|----------|---------|--------|------------------------|
| **Base Case** | £49.5M (flat) | £2.6M (+8%) | LOW |
| **Upside** | £54.0M (+8.6%) | £3.5M (+46%) | NONE |
| **Downside** | £44.0M (-11.5%) | £1.0M (-58%) | MEDIUM |
| **Catastrophic** | <£40M | Negative | **TRIGGERED** |

---

## SCENARIO 1: BASE CASE (Our Target)

**What we're assuming:**
- All current customers retained (except Decathlon - already lost)
- Revenue flat at £49.7M
- No major supply chain disruptions
- SAP implementation proceeds
- Halfords accepts current credit terms

### Year 1 Financial Targets

| Metric | CY-1 Actual | Our Year 1 Target | Change |
|--------|-------------|-------------------|--------|
| Revenue | £49.7M | £49.5M | -0.4% |
| EBITDA | £2.4M | £2.6M | +8% |
| EBITDA Margin | 4.8% | 5.2% | +40bp |
| Operating Cash Flow | £1.64M | £1.8M | +10% |

### Our Key Actions

| Priority | Action | Owner | Deadline |
|----------|--------|-------|----------|
| 1 | Renew all CY expiring contracts | Joshua (CMO) | March |
| 2 | Resolve Halfords credit dispute | Ali (CFO) + Joshua | February |
| 3 | Complete SAP Phase 1 | Jessica (COO) | June |
| 4 | Fork repair completion | Jessica (COO) | February |
| 5 | Retention packages for key staff | Liza (CHRO) | January |

### How We'll Present This to the Board

- "Stabilization year" - we stop the 4-year revenue decline
- Focus on operational efficiency
- Modest EBITDA improvement through cost control
- Prepare foundation for Year 2 growth

### What Could Go Wrong

| Risk | Probability | Impact | Our Mitigation |
|------|-------------|--------|----------------|
| Halfords defects | 30% | £1M revenue loss | Negotiate, find alternatives |
| Colleen leaves | 25% | Operations disrupted | Counter-offer, document processes |
| Bas/Hannah conflict escalates | 40% | Sales dysfunction | Tommy intervention |

---

## SCENARIO 2: UPSIDE CASE (What DratLink Wants)

**What would need to happen:**
- All customers retained and satisfied
- E-bike pilot launched Q3
- Win 2 new retail accounts
- Operational efficiencies realized
- Favorable exchange rates

### Year 1 Financial Results

| Metric | CY-1 Actual | Upside Result | Change |
|--------|-------------|---------------|--------|
| Revenue | £49.7M | £54.0M | +8.6% |
| EBITDA | £2.4M | £3.5M | +46% |
| EBITDA Margin | 4.8% | 6.5% | +170bp |
| Operating Cash Flow | £1.64M | £2.5M | +52% |

### What Would Drive This

| Driver | Revenue Impact | Probability |
|--------|----------------|-------------|
| E-bike launch (pilot) | +£2M | 40% |
| New German account | +£1.5M | 35% |
| New US account | +£1M | 30% |
| Online channel growth | +£0.5M | 50% |

### Investment Required

| Initiative | Investment | Owner |
|------------|------------|-------|
| E-bike R&D | £200,000 | Jessica/Joshua |
| New sales hires | £150,000 | Liza |
| Marketing spend | £100,000 | Joshua |
| Supply chain expansion | £100,000 | Jessica |

---

## SCENARIO 3: DOWNSIDE CASE (What Keeps Us Up at Night)

**What would cause this:**
- Halfords defects (credit dispute)
- One other major customer lost
- Supply chain disruption (Taiwan)
- Key person departure
- Revenue decline continues

### Year 1 Financial Results

| Metric | CY-1 Actual | Downside Result | Change |
|--------|-------------|-----------------|--------|
| Revenue | £49.7M | £44.0M | -11.5% |
| EBITDA | £2.4M | £1.0M | -58% |
| EBITDA Margin | 4.8% | 2.3% | -250bp |
| Operating Cash Flow | £1.64M | £0.5M | -70% |

### The 20% Customer Loss Danger Zone

| Customer Combination Lost | Revenue % | Triggers Default? |
|---------------------------|-----------|-------------------|
| Halfords + Evans | 5% | NO |
| Halfords + Evans + Zweirad-Stadler | 19% | NO (barely) |
| Halfords + Evans + Zweirad-Stadler + REI | 23% | **YES - WE LOSE OUR HOMES** |

### Our Crisis Actions

| Trigger | Action | Owner |
|---------|--------|-------|
| Revenue -5% | Emergency cost reduction | Ali (CFO) |
| Revenue -10% | Staff reduction plan | Liza (CHRO) |
| Cash <£500k | Asset sale (Victoria House) | Ali (CFO) |
| EBITDA <£1.5M | PE emergency funding request | Tommy (CEO) |
| Any major customer defection | Customer save team | Joshua (CMO) |

---

## SCENARIO 4: CATASTROPHIC CASE (Our Personal Nightmare)

**What happens if we hit 20% customer loss:**

```
DAY 0: Customer losses exceed 20% threshold
   │
DAY 1-10: Noteholders issue written demand
   │
DAY 10: Event of Default confirmed
   │
DAY 11: HSBC steps back as guarantor
   │
DAY 11: WE become the guarantors
   │
DAY 12: Written demand served on us personally
   │
DAY 26: We must pay (14 days from demand)
   │
DAY 27+: Our homes are sold
```

### Our Personal Exposure Over Time

| If Default Occurs | Outstanding Balance | Each of Us Owes |
|-------------------|---------------------|-----------------|
| Month 1-6 | £10,000,000 | Up to £10M each |
| Month 7-36 | £7,000,000 | Up to £7M each |
| Month 37-48 | £3,500,000 | Up to £3.5M each |

### Our Prevention Dashboard

| Metric | Safe | Warning | Danger |
|--------|------|---------|--------|
| Customer revenue at risk | <10% | 10-15% | >15% |
| Cash on hand | >£1M | £500K-1M | <£500K |
| AR aging | <60 days | 60-90 days | >90 days |
| Key staff turnover | 0 | 1 person | 2+ people |

---

## OUR FEBRUARY BOARD AGENDA

| Time | Topic | Presenter | What We Need |
|------|-------|-----------|--------------|
| 0:00-0:15 | Deal Completion Status | Tommy | Confirm all closed |
| 0:15-0:45 | Financial Position | Ali | Cash reality, June plan |
| 0:45-1:15 | 100-Day Action Plan | Tommy | Board approval |
| 1:15-1:45 | Customer Retention | Joshua | Contract status |
| 1:45-2:15 | Operations Update | Jessica | Supply chain, SAP |
| 2:15-2:30 | People & Culture | Liza | Key personnel |
| 2:30-3:00 | Year 1 Budget | Ali | Monthly targets |
| 3:00-3:30 | Growth Strategy | Tommy/Joshua | E-bikes, markets |
| 3:30-4:00 | Risk Register | Tommy | Top risks |

---

## WHAT DRATLINK WILL ASK US

| Topic | Their Question | Our Prepared Answer |
|-------|----------------|---------------------|
| **Growth** | "How will you achieve 10-15% CAGR?" | E-bikes, new accounts, online channel |
| **Margins** | "Where are the 200-300bp coming from?" | Procurement, efficiency, mix shift |
| **Customers** | "What's your retention strategy?" | Every contract mapped, relationship owners assigned |
| **E-bikes** | "When will you enter this market?" | Q3 pilot, partnerships being explored |
| **ESG** | "What's your sustainability roadmap?" | Energy audit Q1, wage review Q2 |
| **Cash** | "Can you make the June redemption?" | Victoria House sale or bank facility |
| **Risks** | "What keeps you up at night?" | Customer retention, cash flow, key people |
| **People** | "Is the team stable?" | Retention packages for top 5 |

---

## OUR 100-DAY EXECUTION PLAN

### Days 1-30: Stabilize (NOW)

| Week | Focus | Our Deliverables |
|------|-------|------------------|
| 1-2 | Take control | Bank meetings, staff announcement, customer calls |
| 3-4 | Validate reality | Confirm financials, meet every major customer |

### Days 31-60: Plan (FEBRUARY)

| Week | Focus | Our Deliverables |
|------|-------|------------------|
| 5-6 | Strategy development | 5-year plan draft, budget draft |
| 7-8 | Board preparation | Action plan, targets, risk register |

### Days 61-100: Execute (MARCH-APRIL)

| Week | Focus | Our Deliverables |
|------|-------|------------------|
| 9-10 | First board meeting | Present plan, get approval |
| 11-14 | Quick wins | Contract renewals, cost savings, retention packages |

---

## KEY DECISIONS WE NEED FROM THE BOARD

| # | Decision | Options | Our Recommendation |
|---|----------|---------|-------------------|
| 1 | Victoria House | Sell / Renovate / Hold | Sell to fund June payment |
| 2 | Halfords credit terms | Accept 150 days / Negotiate / Walk | Negotiate to 120 days |
| 3 | E-bike investment | Pilot Y1 / Delay Y2 / Partner | Pilot Q3 Year 1 |
| 4 | SAP implementation | Continue / Pause / Accelerate | Continue as planned |
| 5 | Key staff retention | Packages / Equity / Status quo | Packages for top 5 |

---

## OUR MONTHLY KPIs

### Financial (Ali tracks)

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Revenue vs Budget | ±5% | -5 to -10% | >-10% |
| EBITDA vs Budget | ±10% | -10 to -20% | >-20% |
| Cash Balance | >£1M | £500K-1M | <£500K |
| AR Days | <60 | 60-75 | >75 |

### Customer (Joshua tracks)

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Customer Retention | 100% | 95-99% | <95% |
| Revenue at Risk | <5% | 5-10% | >10% |
| Contract Renewals | 100% | 90-99% | <90% |

### Operations (Jessica tracks)

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| On-Time Delivery | >95% | 90-95% | <90% |
| Production Efficiency | >85% | 80-85% | <80% |
| Inventory Turns | >4x | 3-4x | <3x |

### People (Liza tracks)

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Key Person Retention | 100% | 90% | <90% |
| Overall Turnover | <10% | 10-15% | >15% |

---

# ⚠️ OUR PERSONAL GUARANTEE - WHAT WE'VE COMMITTED

*This is what each of us has personally signed up for.*

---

## What We're Guaranteeing

### The Seller's Note: £10,000,000

We have personally guaranteed the full repayment of the £10M HSBC-Guaranteed Loan Notes.

> "Management will personally guarantee the full amount of the seller's note should the company go into default."
> — Term Sheet, Section VII.G

---

## How the Guarantee Works

### Normal State (Company Performing)

```
┌─────────────────┐      ┌─────────────────┐      ┌─────────────────┐
│    SELLERS      │ ←──  │    MAYWOOD      │ ←──  │      HSBC       │
│  (Noteholders)  │      │   (Borrower)    │      │   (Guarantor)   │
└─────────────────┘      └─────────────────┘      └─────────────────┘
                         Company makes payments
                         HSBC guarantees if company can't pay
                         Management NOT directly liable
```

### Default State (Company Fails to Perform)

```
┌─────────────────┐      ┌─────────────────┐      ┌─────────────────┐
│    SELLERS      │ ←──  │   MANAGEMENT    │      │      HSBC       │
│  (Noteholders)  │      │  TEAM (5 people)│      │   (Steps back)  │
└─────────────────┘      └─────────────────┘      └─────────────────┘
                         YOU make payments
                         HSBC is released
                         Your personal assets seized if you can't pay
```

> "If the Company is in default, management jointly and severally will become the guarantors of the Notes. Thereafter Guarantor will be the Management Team."
> — Loan Note Instrument, Schedule 4, Clause 2

---

## "JOINTLY AND SEVERALLY" - WHAT THIS MEANS

**This is critical legal language.**

| Term | Meaning | Example |
|------|---------|---------|
| **Joint** | All 5 of you are collectively responsible | All 5 sued together |
| **Several** | Each of you is INDIVIDUALLY responsible for the FULL amount | Any ONE of you can be sued for all £10M |
| **Jointly and Severally** | BOTH of the above | Creditors can pursue any combination |

> "The outstanding loan amount payable shall be then the responsibility fully and severally by each member of the Maywood management team."
> — Loan Note Instrument, Schedule 3, Event #12

### Practical Example

If Maywood defaults with £8M still owed:

| Scenario | What Happens |
|----------|--------------|
| **All 5 have assets** | Sellers can sue all 5, collect proportionally |
| **Only Tommy has assets** | Sellers can collect the FULL £8M from Tommy alone |
| **Only you (Joshua) have assets** | Sellers can collect the FULL £8M from you alone |
| **2 people have assets** | Sellers can split collection between those 2 for full £8M |

**You are NOT just liable for 1/5th (£2M). You are liable for the FULL amount.**

---

## WHAT ASSETS ARE AT RISK

### Required Escrow (Before Closing)

> "Management will also put into escrow their title deeds to their primary residences and any other major family assets to secure the seller's note in case of default."
> — Term Sheet, Section VII.H

| Asset Type | Status | What Happens on Default |
|------------|--------|------------------------|
| **Primary Residence** | Title deeds in escrow | Can be sold to satisfy debt |
| **Other Major Family Assets** | In escrow | Can be sold to satisfy debt |
| **Any Other Personal Assets** | Exposed via "several" liability | Can be pursued in court |

### What "In Escrow" Means

Your title deeds are held by a third party (likely the Sellers' solicitors). If default occurs:

1. Escrow agent releases deeds to Sellers/Noteholders
2. They can force sale of your home
3. Proceeds go to debt repayment
4. If insufficient, they pursue other assets

---

## WHEN THE GUARANTEE TRIGGERS

The personal guarantee activates upon ANY Event of Default (Loan Note Instrument, Schedule 3):

| Event # | Trigger | Your Exposure |
|---------|---------|---------------|
| **1** | Non-payment within 10 business days of demand | Full £10M |
| **2** | Winding up order | Full £10M |
| **3** | Cessation of material business without consent | Full £10M |
| **4** | Administrative receiver appointed | Full £10M |
| **5** | Distress/execution not discharged in 20 days | Full £10M |
| **6** | Inability to pay debts (s123 Insolvency Act) | Full £10M |
| **7** | Voluntary arrangement proposal | Full £10M |
| **8** | Administration petition | Full £10M |
| **9** | Material breach not cured in 20 days | Full £10M |
| **10** | **LOSS OF CUSTOMERS >20% OF REVENUE** | **Full £10M** |
| **11** | Guarantee ceases to be valid | Full £10M |

### The 20% Customer Loss Trigger (Event #10)

> "The company loses customers that represent greater than 20% of the company's revenues."
> — Loan Note Instrument, Schedule 3, Event 10

**This is NOT about losing 20% of revenue.** This is about losing CUSTOMERS who REPRESENT 20% of revenue.

| Customer Combination | Revenue % | Triggers Default? |
|---------------------|-----------|-------------------|
| Lose UK (all customers) | 23% | **YES** |
| Lose Germany (all customers) | 16% | NO (but close) |
| Lose Germany + France | 24% | **YES** |
| Lose Halfords + Evans + Cycle Surgery | ~7% | NO |
| Lose REI (US) + Zweirad-Stadler (DE) | ~9% | NO |

**Current risk:** Decathlon already terminating. Halfords demanding extended credit. Multiple contracts expiring.

---

## REPAYMENT OBLIGATIONS (If Guarantee Triggered)

### Outstanding Amount Schedule

| Date | Maximum Redeemed | Outstanding | Your Max Exposure |
|------|------------------|-------------|-------------------|
| Day 1 | £0 | £10,000,000 | £10,000,000 |
| After June Year 1 | £3,000,000 | £7,000,000 | £7,000,000 |
| After Dec Year 3 | £6,500,000 | £3,500,000 | £3,500,000 |
| After Dec Year 4 | £10,000,000 | £0 | £0 |

**Plus accrued interest at LIBOR (or LIBOR+2% if in default)**

### Payment Timeline if Default Occurs

> "Such payment shall be made within fourteen (14) days after the service upon the Guarantor of such written demand."
> — Loan Note Instrument, Schedule 4, Clause 3(A)

**You have 14 days to pay once demand is made.**

---

## DURATION OF GUARANTEE

> "The liability of the Guarantor shall end on 5 years from Completion plus six months"
> — Loan Note Instrument, Schedule 4, Clause 3(B)

| Milestone | Your Liability |
|-----------|----------------|
| Completion | Guarantee ACTIVE |
| Year 1-4 | Guarantee ACTIVE |
| Year 5 | Guarantee ACTIVE |
| Year 5 + 6 months | Guarantee EXPIRES (if no prior default) |

**You are personally exposed for 5.5 years from closing.**

---

## WHAT YOU CANNOT DO (Covenant Restrictions)

While the Preferred Stock is outstanding, you cannot:

| Restriction | Document Reference |
|-------------|-------------------|
| Pay dividends on any stock | Term Sheet, VII.C |
| Repurchase common stock | Term Sheet, VII.C |
| Repay shareholder loans | Term Sheet, VII.C |

**Translation:** You cannot extract money from the company to protect your personal assets.

---

## LIFE INSURANCE REQUIREMENT

> "The Company will make its best efforts to maintain life insurance, with proceeds payable to the company, in the amount of £2 million on the lives of each of the management team."
> — Term Sheet, Section VII.B

| Person | Coverage | Beneficiary |
|--------|----------|-------------|
| Tommy (CEO) | £2,000,000 | Maywood (Company) |
| Jessica (COO) | £2,000,000 | Maywood (Company) |
| Joshua (CMO) | £2,000,000 | Maywood (Company) |
| Liza (CHRO) | £2,000,000 | Maywood (Company) |
| Ali (CFO) | £2,000,000 | Maywood (Company) |

**Note:** This protects the COMPANY, not your family. If you die, the company gets £2M to help operations, but your estate may still be liable under the guarantee.

---

## SUMMARY: YOUR PERSONAL RISK

| Element | Exposure |
|---------|----------|
| **Maximum Liability** | £10,000,000 (full amount, not 1/5th) |
| **Assets at Risk** | Home (in escrow) + all other personal assets |
| **Duration** | 5 years 6 months from closing |
| **Trigger** | Any of 11 Events of Default |
| **Most Likely Trigger** | Customer loss >20% OR cash flow problems |
| **Payment Deadline** | 14 days from demand |
| **Co-Guarantors** | 4 other management team members |
| **But...** | Each of you liable for FULL amount individually |

---

## QUESTIONS TO ASK BEFORE SIGNING

1. **What is the current estimated value of each team member's escrowed assets?**
2. **Can we negotiate a cap on individual liability (e.g., 1/5th each)?**
3. **Can we negotiate carve-outs for certain default triggers?**
4. **What personal liability insurance is available?**
5. **Can the 20% customer loss trigger be increased to 30% or 40%?**
6. **Can we negotiate a shorter guarantee period (3 years instead of 5.5)?**

---

# REFERENCE: UNDERSTANDING OUR STAKEHOLDERS

*This section helps us understand what HSBC (bank) and DratLink (PE) care about.*

---

## Capital Stack
| **Q1 Interest Payment** | ~£100,000 | 31 January |
| **Q2 Interest Payment** | ~£100,000 | 30 April |
| **Director Loan Repayment** | ~~£1,000,000~~ | **PAID IN SALE** |
| **Total Cash Needed (6 months)** | **~£3,200,000** | |

### Cash Available

| Source | Amount | Notes |
|--------|--------|-------|
| Operating Cash Flow (6 mo) | ~£820,000 | Based on £1.64M annual |
| Cash on Hand | £175,000 | Per CY-1 balance sheet |
| Invoice Discounting | Variable | Already being used |
| **Gap** | **~£2,200,000** | Director loans cleared in sale |

### How to Fill the Gap

| Option | Amount | Feasibility | Risk |
|--------|--------|-------------|------|
| Sell Victoria House | £3,000,000 | Medium | Lose future expansion capacity |
| Additional PE injection | Variable | Low | Dilutes management further |
| Bank facility increase | £1-2M | Medium | More debt, more covenants |
| Delay CapEx | £165,000 | Easy | Fork repair can't wait |
| Aggressive AR collection | Variable | Medium | May strain customer relationships |
| Sell US distribution stake | £5.3M book | Difficult | Need Wayne Fairfield consent |

---

## SCENARIO 1: BASE CASE

**Assumptions:**
- All current customers retained (except Decathlon)
- Revenue flat at £49.7M
- No major supply chain disruptions
- SAP implementation proceeds
- Halfords accepts current credit terms

### Year 1 Financials (Base Case)

| Metric | CY-1 Actual | Year 1 Target | Change |
|--------|-------------|---------------|--------|
| Revenue | £49.7M | £49.5M | -0.4% |
| EBITDA | £2.4M | £2.6M | +8% |
| EBITDA Margin | 4.8% | 5.2% | +40bp |
| Operating Cash Flow | £1.64M | £1.8M | +10% |

### Key Actions Required

| Priority | Action | Owner | Deadline |
|----------|--------|-------|----------|
| 1 | Renew all CY expiring contracts | CMO | March |
| 2 | Resolve Halfords credit dispute | CFO/CMO | February |
| 3 | Complete SAP Phase 1 | COO | June |
| 4 | Fork repair completion | COO | February |
| 5 | Retention packages for key staff | CHRO | January |

### Board Presentation Points

- "Stabilization year" - stop revenue decline
- Focus on operational efficiency
- Modest EBITDA improvement through cost control
- Prepare foundation for Year 2 growth

### Risks to Base Case

| Risk | Probability | Impact | Mitigation |
|------|-------------|--------|------------|
| Halfords defects | 30% | £1M revenue loss | Negotiate, find alternatives |
| Colleen leaves | 25% | Operations disrupted | Counter-offer, document processes |
| Bas/Hannah conflict escalates | 40% | Sales team dysfunction | CEO intervention |

---

## SCENARIO 2: UPSIDE CASE

**Assumptions:**
- All customers retained and satisfied
- E-bike pilot launched Q3
- Win 2 new retail accounts
- Operational efficiencies realized
- Favorable exchange rates

### Year 1 Financials (Upside)

| Metric | CY-1 Actual | Year 1 Target | Change |
|--------|-------------|---------------|--------|
| Revenue | £49.7M | £54.0M | +8.6% |
| EBITDA | £2.4M | £3.5M | +46% |
| EBITDA Margin | 4.8% | 6.5% | +170bp |
| Operating Cash Flow | £1.64M | £2.5M | +52% |

### What Would Drive This

| Driver | Revenue Impact | Probability |
|--------|---------------|-------------|
| E-bike launch (pilot) | +£2M | 40% |
| New German account | +£1.5M | 35% |
| New US account | +£1M | 30% |
| Online channel growth (Wiggle/Chain Reactions) | +£0.5M | 50% |

### Board Presentation Points

- "Growth acceleration" - exceeding DratLink expectations
- E-bike market entry validates investment thesis
- Demonstrates management capability
- Sets up strong Year 2

### Requirements for Upside

| Requirement | Investment | Owner |
|-------------|------------|-------|
| E-bike R&D | £200,000 | COO/CMO |
| New sales hires | £150,000 | CHRO |
| Marketing spend | £100,000 | CMO |
| Supply chain expansion | £100,000 | COO |

---

## SCENARIO 3: DOWNSIDE CASE

**Assumptions:**
- Halfords defects (credit dispute)
- One other major customer lost
- Supply chain disruption (Taiwan)
- Key person departure
- Revenue decline continues

### Year 1 Financials (Downside)

| Metric | CY-1 Actual | Year 1 Result | Change |
|--------|-------------|---------------|--------|
| Revenue | £49.7M | £44.0M | -11.5% |
| EBITDA | £2.4M | £1.0M | -58% |
| EBITDA Margin | 4.8% | 2.3% | -250bp |
| Operating Cash Flow | £1.64M | £0.5M | -70% |

### What Would Cause This

| Event | Revenue Impact | Probability |
|-------|---------------|-------------|
| Halfords defects | -£1.0M | 30% |
| Evans reduces orders | -£1.5M | 20% |
| Taiwan supply disruption | -£2.0M (delayed orders) | 25% |
| Colleen + 1 other leaves | -£1.0M (inefficiency) | 20% |

### Danger Zone: 20% Customer Loss Trigger

| Scenario | Revenue Lost | % of Total | Default? |
|----------|-------------|------------|----------|
| Halfords + Evans | £2.5M | 5% | NO |
| Halfords + Evans + Zweirad-Stadler | £9.5M | 19% | NO (barely) |
| Halfords + Evans + Zweirad-Stadler + REI | £11.5M | 23% | **YES** |

### Crisis Actions Required

| Priority | Action | Owner | Trigger |
|----------|--------|-------|---------|
| 1 | Emergency cost reduction | CFO | Revenue -5% |
| 2 | Staff reduction plan | CHRO | Revenue -10% |
| 3 | Asset sale (Victoria House) | CFO | Cash <£500k |
| 4 | PE emergency funding request | CEO | EBITDA <£1.5M |
| 5 | Customer save team | CMO | Any major defection |

### Board Presentation Points

- Transparent about challenges
- Clear turnaround plan
- Cost reduction levers identified
- Request for PE support if needed

---

## SCENARIO 4: CATASTROPHIC CASE

**Assumptions:**
- 20% customer loss trigger hit
- Personal guarantee activated
- Loan accelerated

### What Happens

```
DAY 0: Customer losses exceed 20%
   │
DAY 1-10: Noteholders issue written demand
   │
DAY 10: Event of Default confirmed
   │
DAY 11: HSBC steps back as guarantor
   │
DAY 11: Management becomes guarantor
   │
DAY 12: Written demand served on Management
   │
DAY 26: Payment due (14 days from demand)
   │
DAY 27+: Personal asset seizure begins
```

### Personal Exposure at Various Points

| If Default Occurs | Outstanding Balance | Your Exposure |
|-------------------|---------------------|---------------|
| Month 1-6 (before June redemption) | £10,000,000 | £10,000,000 each |
| Month 7-36 (after first redemption) | £7,000,000 | £7,000,000 each |
| Month 37-48 (after second redemption) | £3,500,000 | £3,500,000 each |

### Prevention Checklist

| Metric | Safe Zone | Warning Zone | Danger Zone |
|--------|-----------|--------------|-------------|
| Customer revenue at risk | <10% | 10-15% | >15% |
| Cash on hand | >£1M | £500K-1M | <£500K |
| Accounts receivable aging | <60 days | 60-90 days | >90 days |
| Key staff turnover | 0 | 1 person | 2+ people |

---

## BOARD MEETING AGENDA (RECOMMENDED)

### February Board Meeting

| Time | Topic | Presenter | Materials |
|------|-------|-----------|-----------|
| 0:00-0:15 | Deal Completion Status | CEO | Closing checklist |
| 0:15-0:45 | Financial Position | CFO | Cash flow, AR/AP, facilities |
| 0:45-1:15 | 100-Day Action Plan | CEO | Plan document |
| 1:15-1:45 | Customer Retention Status | CMO | Contract renewals, risks |
| 1:45-2:15 | Operations Update | COO | Supply chain, SAP, capacity |
| 2:15-2:30 | People & Culture | CHRO | Key personnel, retention |
| 2:30-3:00 | Year 1 Budget & Targets | CFO | Monthly targets, KPIs |
| 3:00-3:30 | Growth Strategy | CEO/CMO | E-bikes, new markets |
| 3:30-4:00 | Risk Register | CEO | Top 10 risks, mitigations |

---

## KEY METRICS TO TRACK (MONTHLY)

### Financial KPIs

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Revenue vs Budget | ±5% | -5 to -10% | >-10% |
| EBITDA vs Budget | ±10% | -10 to -20% | >-20% |
| Cash Balance | >£1M | £500K-1M | <£500K |
| AR Days | <60 | 60-75 | >75 |
| AP Days | 45-60 | >60 | >75 |

### Customer KPIs

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Customer Retention | 100% | 95-99% | <95% |
| Revenue at Risk | <5% | 5-10% | >10% |
| Contract Renewals | 100% | 90-99% | <90% |
| NPS (if measured) | >50 | 30-50 | <30 |

### Operational KPIs

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| On-Time Delivery | >95% | 90-95% | <90% |
| Production Efficiency | >85% | 80-85% | <80% |
| Inventory Turns | >4x | 3-4x | <3x |
| Defect Rate | <2% | 2-5% | >5% |

### People KPIs

| Metric | Target | Warning | Critical |
|--------|--------|---------|----------|
| Key Person Retention | 100% | 90% | <90% |
| Overall Turnover | <10% | 10-15% | >15% |
| Open Positions | <5 | 5-10 | >10 |
| Training Hours | >20/person | 10-20 | <10 |

---

## DRATLINK EXPECTATIONS (What They'll Ask)

### Questions to Prepare For

| Topic | Likely Question | Your Answer Should Include |
|-------|-----------------|---------------------------|
| **Growth** | "How will you achieve 10-15% CAGR?" | E-bikes, new accounts, online channel |
| **Margins** | "Where are the 200-300bp coming from?" | Procurement, efficiency, mix shift |
| **Customers** | "What's your retention strategy?" | Contract status, relationship plan |
| **E-bikes** | "When will you enter this market?" | Timeline, investment, partnerships |
| **ESG** | "What's your sustainability roadmap?" | Energy, wages, community |
| **Cash** | "Can you make the June redemption?" | Sources, contingencies |
| **Risks** | "What keeps you up at night?" | Top 3 risks + mitigations |
| **People** | "Is the team stable?" | Retention actions, succession |

### How to Frame Bad News

| Bad News | How to Present |
|----------|----------------|
| Revenue flat/declining | "Stabilization before growth" |
| Customer at risk | "Proactive management, alternatives identified" |
| Key person leaving | "Succession plan in place, knowledge transfer underway" |
| Cash tight | "Working capital optimization in progress, contingencies ready" |
| Miss target | "Root cause identified, corrective action implemented" |

---

## 100-DAY PLAN FRAMEWORK

### Days 1-30: Stabilize

| Week | Focus | Deliverables |
|------|-------|--------------|
| 1-2 | Close deal, take control | Signing, bank meetings, staff announcement |
| 3-4 | Assess reality vs DD | Validate financials, meet key customers, meet key staff |

### Days 31-60: Plan

| Week | Focus | Deliverables |
|------|-------|--------------|
| 5-6 | Strategy development | 5-year plan draft, budget draft |
| 7-8 | Board preparation | Action plan, targets, risk register |

### Days 61-100: Execute

| Week | Focus | Deliverables |
|------|-------|--------------|
| 9-10 | First board meeting | Present plan, get approval |
| 11-14 | Implement quick wins | Contract renewals, cost savings, retention |

---

## DECISION LOG (Template for Board)

| # | Decision Needed | Options | Recommendation | Board Decision | Date |
|---|-----------------|---------|----------------|----------------|------|
| 1 | Victoria House disposition | Sell / Renovate / Hold | Hold for Year 1 | | |
| 2 | Halfords credit terms | Accept 150 days / Negotiate / Walk | Negotiate to 120 | | |
| 3 | E-bike investment | Pilot in Y1 / Delay to Y2 / Partner | Pilot Q3 Year 1 | | |
| 4 | SAP implementation | Continue / Pause / Accelerate | Continue | | |
| 5 | Key staff retention | Packages / Equity / Status quo | Packages for top 5 | | |

---

# BANK & EQUITY PERSPECTIVE: DEAL ANALYSIS

*This section analyzes the deal from the perspective of HSBC (Guarantor) and DratLink Capital (PE Investor)*

---

## DEAL STRUCTURE OVERVIEW

### Capital Stack

| Layer | Amount | Provider | Document Source |
|-------|--------|----------|-----------------|
| Senior Debt (Seller's Note) | £10,000,000 | HSBC-Guaranteed Loan Notes | Loan Note Instrument |
| Equity | £10,000,000 | DratLink Capital | Term Sheet, Investment Memo |
| **Total Acquisition** | **£20,000,000** | | |

### Target Company Metrics (CY-1)

| Metric | Value | Source |
|--------|-------|--------|
| Revenue | £49.7M | DD Report - P&L |
| EBITDA | £2.4M | DD Report - P&L |
| Net Profit | £376k | DD Report - P&L |
| Net Equity | £23.2M | DD Report - Balance Sheet |
| Total Assets | £42.0M | DD Report - Balance Sheet |

### Implied Valuation Multiples

| Multiple | Calculation | Value |
|----------|-------------|-------|
| EV/Revenue | £20M / £49.7M | 0.40x |
| EV/EBITDA | £20M / £2.4M | 8.3x |
| Price/Book | £20M / £23.2M | 0.86x |

**Assessment:** Acquiring below book value (0.86x) suggests either distressed pricing or significant hidden liabilities/risks.

---

## HSBC POSITION: LOAN NOTE GUARANTEE

### Facility Terms

| Term | Value | Document Reference |
|------|-------|-------------------|
| Principal | £10,000,000 | Loan Note Instrument, Clause 2.3 |
| Interest Rate | LIBOR | Loan Note Instrument, Clause 3.1 |
| Default Rate | LIBOR + 2% | Loan Note Instrument, Clause 3.4 |
| Term | 4 years | Loan Note Instrument, Clause 1.1 ("Final Redemption Date") |
| Denominations | £10,000 minimum | Loan Note Instrument, Clause 2.3 |

### Redemption Schedule

| Date | Maximum | Cumulative | Document Reference |
|------|---------|------------|-------------------|
| 20 June Year 1 | 30% (£3.0M) | 30% | Loan Note Instrument, Clause 4.1 |
| 20 December Year 3 | 35% (£3.5M) | 65% | Loan Note Instrument, Clause 4.1 |
| 20 December Year 4 | 35% (£3.5M) | 100% | Loan Note Instrument, Clause 4.1 |

### Interest Payment Schedule

> "Accrued interest on the Notes shall be payable by equal quarterly instalments in arrears on each Interest Payment Date"
> — Loan Note Instrument, Clause 3.3

| Payment Dates | Frequency |
|---------------|-----------|
| 31 January, 30 April, 31 July, 31 October | Quarterly |

### HSBC Risk Mitigation: Events of Default

**Source:** Loan Note Instrument, Schedule 3

| Event # | Trigger | HSBC Protection |
|---------|---------|-----------------|
| 1 | Non-payment within 10 business days of demand | Accelerate full loan |
| 2 | Winding up order | Accelerate full loan |
| 3 | Cessation of material business without consent | Accelerate full loan |
| 6 | Inability to pay debts (s123 Insolvency Act) | Accelerate full loan |
| **10** | **Loss of customers >20% of revenue** | **Accelerate full loan** |
| 11 | Guarantee ceases to be valid | Accelerate full loan |
| **12** | **Management becomes personally liable** | **Guarantee cascade** |

### HSBC Guarantee Cascade

> "If the Company is in default, management jointly and severally will become the guarantors of the Notes. Thereafter Guarantor will be the Management Team."
> — Loan Note Instrument, Schedule 4, Clause 2

**Structure:**
```
NORMAL STATE:           DEFAULT STATE:
┌─────────────┐         ┌─────────────┐
│   HSBC      │         │ Management  │
│ (Guarantor) │   →→→   │ (5 people)  │
└─────────────┘         └─────────────┘
```

### HSBC Security Analysis

| Security | Value | Encumbered? | Notes |
|----------|-------|-------------|-------|
| Maywood House | ~£7.8M | YES - NatWest mortgage | £5.77M owed |
| Facility B | Included above | YES - NatWest mortgage | |
| Victoria House | ~£3.0M | NO | Needs renovation |
| Site Land | ~£5.0M | NO | Unencumbered |
| US Distribution Stake (49%) | £5.3M book | NO | Wayne Fairfield controls |
| Plant & Machinery | £5.9M | PARTIAL - HP agreements | ~£2.25M HP outstanding |

**Unencumbered Asset Coverage:** ~£13.3M vs £10M loan = **1.33x coverage**

### HSBC Concerns

1. **Customer Concentration:** Top customers represent significant revenue concentration. 20% loss trigger is real risk.
   - *Source: DD Report - Sales per Country, Retailer Contracts*

2. **Cash Flow for Debt Service:**
   - Operating cash flow (CY-1): £1.64M
   - Year 1 redemption requirement: £3.0M + interest
   - **Gap:** ~£1.4M must come from working capital or asset sales

3. **Existing Debt Load:**
   - NatWest mortgage: £5.77M (callable on change of control)
   - HP obligations: ~£2.25M
   - *Source: DD Report - Outstanding Loans*

4. **Management Guarantee Value:** Personal assets in escrow, but liquid value unknown.

---

## DRATLINK POSITION: EQUITY INVESTMENT

### Investment Terms

| Term | Value | Document Reference |
|------|-------|-------------------|
| Investment Amount | £10,000,000 | Term Sheet, Section I |
| Common Stock | 900,000 shares (90%) | Term Sheet, Section I |
| Preferred Stock | 9,000,000 shares (100%) | Term Sheet, Section I |
| Board Seats | 3 of 5 | Term Sheet, Section III.A |

### Preferred Stock Economics

| Feature | Terms | Document Reference |
|---------|-------|-------------------|
| Liquidation Preference | Full investment returned FIRST before common | Term Sheet, Section I |
| Accruing Dividend | 15% per annum, deferred, paid at exit | Term Sheet, Section I |
| Conversion Right | 60% of new common on conversion | Term Sheet, Section I |
| Redemption Option | Year 6 at greater of FMV or cost + dividends | Term Sheet, Section I |

### DratLink 5-Year Return Modeling

**Source:** DratLink Investment Memo

| Scenario | Revenue CAGR | Exit EBITDA | Exit Multiple | Equity Value | DratLink Return |
|----------|--------------|-------------|---------------|--------------|-----------------|
| Base Case | 10% | £4.2M | 8x | £33.6M | 2.4x |
| Upside | 15% | £5.5M | 10x | £55.0M | 4.0x |
| Downside | 5% | £2.8M | 6x | £16.8M | 1.0x |

*Note: Returns to DratLink calculated after liquidation preference + accrued dividends (~£17.5M at Year 5)*

### DratLink Target Returns

> "Revenue Growth: Drive a 10–15% compound annual growth rate"
> "EBITDA Improvements: Enhance profitability by 200–300 basis points"
> — DratLink Investment Memo, Section 4

| Metric | Current | Target | Gap |
|--------|---------|--------|-----|
| Revenue | £49.7M | £80-100M (5yr) | +60-100% |
| EBITDA Margin | 4.8% | 7-8% | +200-300bp |
| EBITDA | £2.4M | £5.6-8.0M | +133-233% |

### DratLink Control Mechanisms

| Mechanism | Terms | Document Reference |
|-----------|-------|-------------------|
| Board Control | 3 of 5 seats | Term Sheet, III.A |
| Drag Along Rights | YES (Management has NO reciprocal) | DD Lawyer Briefing |
| Tag Along Rights | YES (Management has NO reciprocal) | DD Lawyer Briefing |
| Preemptive Rights | YES | Term Sheet, VI.A |
| Management Vesting | Forfeit unvested + forced sale if leave | DD Lawyer Briefing |
| Compensation Control | Set by committee with DratLink rep | Term Sheet, III.B |

### DratLink ESG Requirements

> "Workforce Well-Being: Implement fair wage policies, skill-building programs, and safe working environments"
> "Resource Efficiency: Reduce energy consumption and material waste"
> — DratLink Investment Memo, Section 4

**Implication:** Current wage freeze (noted in DD) conflicts with PE ESG mandate.

### DratLink Growth Strategy Priorities

| Priority | Current State | Required Investment |
|----------|---------------|---------------------|
| **E-bikes** | Not in portfolio | Product development, new supply chain |
| International Expansion | 77% non-UK already | Marketing, distribution |
| Customized Products | Limited | R&D investment |

*Source: DratLink Investment Memo, Section 3*

### DratLink Concerns

1. **Revenue Decline:** 4 consecutive years of decline (54.2M → 49.7M)
   - *Source: DD Report - P&L*

2. **Margin Compression:** High fixed costs, wage pressure building
   - *Source: DD Report - Key Issues*

3. **Customer Risk:** Decathlon already terminating; Halfords demanding extended credit
   - *Source: Disclosure Letter 4.7, 5.1*

4. **Supply Chain:** Single-source frame supplier (Taiwan) with US trade barriers
   - *Source: DD Report - Supplier Analysis*

5. **Management Dependency:** Key personnel flight risk (Colleen, Bas)
   - *Source: Work Journal notes*

---

## JOINT BANK/PE REQUIREMENTS

### Conditions Precedent to Closing

| Requirement | Status | Responsible Party |
|-------------|--------|-------------------|
| NatWest mortgage continuation | **PENDING** | CEO/CFO negotiate |
| HP agreement continuation | **PENDING** | CEO/CFO negotiate |
| Director loan repayment | **COMPLETED IN SALE** | Sellers |
| Personal guarantees executed | **PENDING** | Management Team |
| Asset escrow (homes) | **PENDING** | Management Team |
| Barclays facility continuation | **PENDING** | CEO/CFO negotiate |

### Covenants (Ongoing)

| Covenant | Requirement | Document Reference |
|----------|-------------|-------------------|
| Monthly Financials | Within 30 days of month-end | Term Sheet, VII.A |
| Annual Budget | Before fiscal year-end | Term Sheet, VII.A |
| Annual Audit | Within 90 days of year-end | Term Sheet, VII.A |
| Life Insurance | £2M on each management team member | Term Sheet, VII.B |
| No Dividends | While preferred outstanding | Term Sheet, VII.C |
| No Stock Repurchase | While preferred outstanding | Term Sheet, VII.C |
| No Shareholder Loan Repayment | While preferred outstanding | Term Sheet, VII.C |

### Action Plan Deadline

> "The company will prepare an action plan and monthly targets by the time of the first board meeting in February this year."
> — Term Sheet, VII.F

---

## DEAL RISK SUMMARY (BANK/PE VIEW)

| Risk Category | Specific Risk | Likelihood | Impact | Mitigation |
|---------------|---------------|------------|--------|------------|
| **Credit** | Customer loss >20% triggers default | Medium | Catastrophic | Diversification, retention |
| **Credit** | Cash flow insufficient for Year 1 redemption | Medium | High | Working capital management |
| **Operational** | Key person departure | Medium | High | Retention packages |
| **Operational** | Supply chain disruption (Taiwan) | Medium | High | Alternative suppliers |
| **Market** | Continued revenue decline | Medium | High | Growth initiatives (e-bikes) |
| **Execution** | Miss PE return targets | Medium | High | Aggressive growth plan |
| **Legal** | NatWest calls mortgage | Low | Critical | Pre-close negotiation |
| **Legal** | HP agreements terminated | Low | High | Pre-close confirmation |

---

# SELLER NEGOTIATION: COMPANY FINANCIAL LIABILITIES

## Balance Sheet Snapshot (CY-1)

| Category | Amount |
|----------|--------|
| **Total Assets** | £41,979,535 |
| **Net Equity** | £23,224,836 |
| **Total Liabilities** | £18,754,699 |

---

## DEBT OBLIGATIONS

### Long-Term Debt

| Creditor | Amount | Security | Risk |
|----------|--------|----------|------|
| **NatWest Mortgage** | £5,773,555 | Maywood House + Facility B | **CALLABLE on change of control** |
| **Total Long-Term** | **£5,773,555** | | |

### Short-Term Debt Facilities

| Facility | Limit | Current Use | Terms |
|----------|-------|-------------|-------|
| Barclays Overdraft | £500,000 | Variable | On demand |
| Barclays Invoice Discounting | £5,000,000 | Variable (85% of orders) | 4% fee |

### Loans Requiring Immediate Repayment at Acquisition

| Loan | Amount | Source | Issue |
|------|--------|--------|-------|
| **Director Loans** | ~~£1,000,000~~ | Directors/Shareholders | **PAID OFF IN SALE** |
| **Connected Persons' Loans** | £500,000 | Key staff (MIL) | Per SPA |
| **Total Due at Close** | **£500,000** | | Director loans cleared |

**RESOLVED:** Director Loans (£1M) were paid off in the sale. Only Connected Persons' Loans (£500k) remain.

---

## HIRE PURCHASE OBLIGATIONS (9% interest, Acme Amalgamated)

| Equipment | Original Value | Term | Purchased | Remaining |
|-----------|---------------|------|-----------|-----------|
| Race bike painting bath | £275,000 | 36 mo | Mar CY-1 | ~18 mo |
| Race bike assembly desks | £670,000 | 48 mo | Feb CY-2 | ~30 mo |
| Road bike assembly desks | £780,000 | 48 mo | Feb CY-2 | ~30 mo |
| MTB assembly desks | £460,000 | 48 mo | Feb CY-2 | ~30 mo |
| Children's bike line | £905,000 | 36 mo | Oct CY | ~36 mo |
| **TOTAL ORIGINAL VALUE** | **£3,090,000** | | | |

**Outstanding Balance (estimated):** ~£2,000,000 - £2,500,000

**RISK:** Disclosure Letter 3.6 states lease obligations contain **change-of-control termination clauses**. These could be called on acquisition.

| In Default | Amount | Status |
|------------|--------|--------|
| Pipe/Tube Bending HP | £40,000 | Equipment scrapped, repayable on demand |

**NEGOTIATION POINT:** Get written confirmation HP agreements will continue post-acquisition, or reduce price by outstanding HP balance.

---

## PROVISIONS & DEFERRED LIABILITIES

| Item | Amount | Deadline | Notes |
|------|--------|----------|-------|
| **Pension Provisions** | £2,219,372 | 31 Dec CY+2 | Deferred contributions, MUST be paid |
| Scottish Widows Deferral | £120,000 | Over 3 years | Additional pension catch-up |
| Deferred Tax Shortfall | ~£350,000 | Ongoing | Provision insufficient by £350k |
| **TOTAL DEFERRED** | **~£2,689,372** | | |

**NEGOTIATION POINT:** These are pre-existing obligations from the sellers' management. Request:
1. Price reduction of £2.2M for pension provisions, OR
2. Sellers fund an escrow for pension catch-up payments

---

## CURRENT LIABILITIES

| Item | Amount | Notes |
|------|--------|-------|
| Accounts Payable | £4,951,133 | Trade creditors |
| Other Current Liabilities (VAT) | £810,639 | HMRC quarterly |
| **TOTAL CURRENT** | **£5,761,772** | |

---

## UPCOMING CAPITAL REQUIREMENTS (Not in Liabilities)

| Item | Amount | Timing | Source |
|------|--------|--------|--------|
| Fork Preparation Repair | £50,000 | January | Disclosure 8.3(a) |
| Environmental Waste Solution | £75,000-100,000 | Summer | Disclosure 13.2 |
| Victoria House Rewiring | £28,000 | In progress | Disclosure 7.3 |
| **TOTAL CAPEX NEEDED** | **~£153,000-178,000** | | |

**NEGOTIATION POINT:** These are known required expenditures. Request price reduction or completion escrow.

---

## SUMMARY: TOTAL LIABILITY EXPOSURE

| Category | Amount | Negotiable? |
|----------|--------|-------------|
| NatWest Mortgage | £5,773,555 | Refinance risk - discuss with lender |
| Director/Connected Loans | £1,500,000 | **YES - Sellers should clear before close** |
| Hire Purchase (est. balance) | ~£2,250,000 | **YES - Confirm continuation or reduce price** |
| Pension Provisions | £2,219,372 | **YES - Pre-existing seller obligation** |
| Other Deferred | £470,000 | Partial |
| Accounts Payable | £4,951,133 | Normal trade |
| Other Current | £810,639 | Normal operations |
| Known CapEx Needs | ~£165,000 | **YES - Known expenses** |
| **TOTAL** | **~£18,139,699** | |

---

## NEGOTIATION STRATEGY

### Request from Sellers BEFORE Completion:

| Item | Amount | Rationale |
|------|--------|-----------|
| Clear Director Loans | ~~£1,000,000~~ PAID IN SALE | Cleared by sellers |
| Clear Connected Persons' Loans | £500,000 | Still required |
| **Sub-total** | **£500,000** | Director loans already cleared |

### Request as Price Reduction OR Escrow:

| Item | Amount | Rationale |
|------|--------|-----------|
| Pension provision catch-up | £2,219,372 | Pre-existing obligation, not created by new management |
| Known CapEx (fork repair, environmental, rewiring) | £165,000 | Identified in DD, known expenses |
| HP default settlement | £40,000 | Equipment scrapped, liability remains |
| Deferred tax shortfall | £350,000 | Accounting deficiency |
| **Sub-total** | **£2,774,372** | |

### Total Negotiation Value: **£4,274,372**

---

## UNENCUMBERED ASSETS (Leverage in Negotiation)

| Asset | Estimated Value | Status |
|-------|----------------|--------|
| Victoria House | ~£3,000,000 | Unused, needs renovation |
| Maywood Site Land | ~£5,000,000 | Unencumbered |
| 49% US Distribution Stake | £5,316,323 | Book value (Wayne Fairfield owns 51%) |
| **TOTAL UNENCUMBERED** | **~£13,316,323** | |

These assets could:
1. Secure additional financing if needed
2. Be sold to reduce debt burden
3. Provide collateral for HP continuation negotiations

---

# CRITICAL: DEAL STRUCTURE & PERSONAL LIABILITY

## The Deal at a Glance

| Component | Amount | Source |
|-----------|--------|--------|
| Equity Investment | £10M | DratLink Capital (PE) |
| Seller's Note | £10M | HSBC-Guaranteed Loan Notes |
| **Total Acquisition** | **£20M** | |

---

## LOAN NOTE STRUCTURE (SELLER'S NOTE)

### £10M LIBOR Guaranteed Series A Loan Notes

**Guarantor:** HSBC PLC (initially)

**Interest Rate:** LIBOR (quarterly payments: Jan 31, Apr 30, Jul 31, Oct 31)

**Default Rate:** LIBOR + 2%

### Redemption Schedule

| Date | Maximum % | Cumulative |
|------|-----------|------------|
| 20 June Year 1 | 30% (£3M) | 30% |
| 20 December Year 3 | 35% (£3.5M) | 65% |
| 20 December Year 4 | 35% (£3.5M) | 100% |

---

## EVENTS OF DEFAULT - READ CAREFULLY

### Event #10: CUSTOMER LOSS TRIGGER
> **"The company loses customers that represent greater than 20% of the company's revenues."**

**IMPLICATION:** If we lose customers totaling >20% of revenue, this triggers a default. Current at-risk customers:
- Halfords (UK): ~2% of total revenue (demanding 150-day credit)
- Decathlon (FR): ~0.1% (TERMINATING)
- Multiple contracts expiring CY

### Event #12: MANAGEMENT PERSONAL LIABILITY
> **"The outstanding loan amount payable shall be then the responsibility fully and severally by each member of the Maywood management team."**

### Schedule 4 - Guarantee Cascade
> **"If the Company is in default, management jointly and severally will become the guarantors of the Notes. Thereafter Guarantor will be the Management Team."**

**PLAIN ENGLISH:** If Maywood defaults, HSBC steps back and the five of you (Tommy, Jessica, Joshua, Liza, Ali) become PERSONALLY responsible for the full outstanding loan amount - jointly and severally.

---

## EQUITY STRUCTURE - MANAGEMENT vs PE

### Ownership Split

| Holder | Common Stock | Preferred Stock |
|--------|-------------|-----------------|
| **Management Team** | 10% (100,000 shares) | None |
| **DratLink (PE)** | 90% (900,000 shares) | 100% (9,000,000 shares) |

### PE Preferred Stock Terms

1. **Liquidation Preference:** PE gets paid back FIRST in any exit before Management sees anything
2. **Accruing Dividend:** 15% per annum on preferred stock (deferred, paid at exit)
3. **Convertible:** Can convert to 60% of new common shares
4. **Redemption Option:** PE can force redemption at Year 6 at greater of FMV or cost + accrued dividends

### Rights Imbalance

| Right | PE (DratLink) | Management |
|-------|---------------|------------|
| Drag Along | YES | NO |
| Tag Along | YES | NO |
| Board Seats | 3 | 2 |
| Preemptive Rights | YES | NO |

### Vesting Schedule
> "Any buying Manager leaving the company pre-exit event for whatever reason forfeits all his or her unvested shares and must sell any vested shares at a pre-determined price."

**IMPLICATION:** If you leave before exit, you lose unvested equity and must sell vested shares at a set price (not market).

---

## DRATLINK EXPECTATIONS (PE INVESTOR)

### Financial Targets
- **Revenue Growth:** 10-15% CAGR
- **EBITDA Improvement:** 200-300 basis points

### ESG/Sustainability Requirements
- Resource efficiency (renewable energy, recycled materials)
- Workforce well-being (fair wages, skill-building, safety)
- Community engagement partnerships

### Exit Timeline
- **Target:** 5-7 years
- **Method:** Strategic sale or IPO
- **IPO Hurdle:** £50M new capital raised at 5x conversion price

### Growth Opportunities Identified by PE
- **E-bikes** - mentioned as key expansion opportunity
- International market expansion
- Customized lifestyle products

---

## PERSONAL GUARANTEE REQUIREMENTS

From Term Sheet (VII.G & VII.H):
> "Management will personally guarantee the full amount of the seller's note should the company go into default."

> "Management will also put into escrow their title deeds to their primary residences and any other major family assets to secure the seller's note in case of default."

**Your homes are collateral.**

---

## REPS AND WARRANTIES

- Capped at **£1M** of purchase price
- Standard indemnities apply

---

## TAX COVENANT HIGHLIGHTS

- Pre-Completion Relief loss threshold: £250,000
- Tax liability notification: Within 10 Business Days
- Seller handles pre-completion tax returns

---

# I. Purchasing & Supplier Due Diligence

### Critical Red Flags

#### 1. Decathlon Terminating Orders
> "Decathlon Ltd has given six months notice to the Company that due to the proposed ownership of the Company by the Purchaser it will terminate its orders to the Company."
- **Source:** Disclosure Letter 5.1
- **Impact:** While only 1% of French sales, signals potential customer flight due to ownership change
- **Risk:** Other customers may follow

#### 2. Halfords Demanding Extended Credit
> "An approach has been received from Halfords Ltd for an increase in credit terms from 90 days to 150 days."
- **Source:** Disclosure Letter 4.7
- **Impact:** Halfords = 9% of UK sales; UK = 23% of total revenue
- **Status:** Currently being resisted

---

### Supplier Concentration Risk

| Supplier | % of Purchases | Component | Risk Level |
|----------|---------------|-----------|------------|
| **Zhongshan** | 22.3% | Frames & Forks | **CRITICAL** - Taiwan, blocked from US |
| Mavic | 17.9% | High-end wheels | HIGH - Single source for race bikes |
| SRAM | 16.5% | Drivetrain | MEDIUM - US-based |
| MRP | 7.2% | Components | LOW |
| Shimano | 4.7% | Drivetrain | LOW - Alternative to SRAM |

**Concentration:** Top 3 suppliers = 56.6% of purchases

---

### Supply Chain Vulnerabilities

#### Just-in-Time Risk (Disclosure Letter 8.2)
> "The Company operates a 'just in time system' for purchases of tubes. If these supplies were interrupted by reasons beyond its control, for example by a port blockade, stocks of tubes might not be adequate for normal production levels."

#### Taiwan/US Trade Barrier
- Taiwan factory (Zhongshan) blocked from shipping goods into US
- Affects 12% of revenue (US market)
- Requires alternative routing or supplier diversification

---

### Retailer Contract Expiration Schedule

| Retailer | Country | Contract End | Risk Factor |
|----------|---------|-------------|-------------|
| **Halfords** | UK | CY | 10% late penalty + credit demand |
| **Decathlon** | FR | CY | **TERMINATING** |
| Chain Reactions | Online | CY | 1-year term |
| Wiggle | Online | CY | 1-year term |
| Velo Vermeulen | BE | CY | 1-year term |
| Radsport | DE | CY+1 | Short term |
| Zweirad-Stadler | DE | CY+2 | Full indemnification clause |
| Bike Totaal | NL | CY+2 | 25% late penalty |

---

### Late Delivery Penalty Exposure

| Retailer | Penalty Structure |
|----------|-------------------|
| Cycle Surgery (UK) | 25% reduction of invoice value |
| Bike Totaal (NL) | 25% reduction of invoice value |
| Evans Cycles (UK) | 10% reduction of invoice value |
| Halfords (UK) | 10% reduction of invoice value |
| Zweirad-Stadler (DE) | Full indemnification of costs/losses |
| French retailers | 1% per day up to 5 days |

---

### Change of Control Triggers

| Obligation | Amount | Trigger Risk |
|------------|--------|--------------|
| NatWest Mortgage | £4.8M | Repayable on demand post-acquisition |
| Equipment Leases | ~£3M | Termination clauses activated |
| Pipe/Tube HP | £40k | Already in default (equipment scrapped) |
| Director Loans | ~~£1M~~ | **PAID OFF IN SALE** |

---

## II. C-Suite Concerns by Function

### CEO (Tommy) - Strategic & Governance

#### Acquisition Structure Risks
- **£20M total acquisition** (£10M equity + £10M seller's note)
- **Personal guarantees required** - Management guarantees seller's note
- **Escrow of personal assets** - Title deeds to primary residences as security
- **Board composition:** PE gets 3 seats, Management retains 2

#### PE Relationship Management
- DratLink expects **10-15% CAGR** and **200-300bp EBITDA improvement**
- ESG/sustainability reporting required
- **Exit timeline:** 5-7 years (strategic sale or IPO)
- Monthly financials due within 30 days
- Action plan due by first board meeting (February)

#### Critical Default Triggers
1. **20% customer loss** triggers loan default → personal liability cascade
2. **Year 6 redemption** - PE can force buyout at FMV or cost + 15% accrued dividends

#### Strategic Concerns
1. Customer retention is now EXISTENTIAL (20% loss = default)
2. 49% stake in US distribution (Wayne Fairfield owns controlling 51%)
3. Brand value and Tour de France sponsorship - align with PE ESG expectations
4. **E-bikes** - PE specifically mentioned as growth opportunity
5. Must hit aggressive growth targets or face PE pressure

---

### COO (Jessica) - Operations & Supply Chain

#### Production Risks
1. **Assembly-only operation** - Maywood makes none of the core components
   - Frames: Taiwan (Zhongshan)
   - Components: Italy
   - Drivetrain: Vietnam
   - Assembly: UK (Birmingham)

2. **"Organized chaos"** - Processes built organically through experience
   - Bas's brother is the "handyman" running the system
   - No standardized procedures documented

3. **Seasonality pressure**
   - 51% of revenue in first 5 months
   - Peak FOB sales: Feb-Apr and September
   - Working capital strain during inventory build-up

#### Capital Equipment Status
| Equipment | Purchase Date | HP Value | Term |
|-----------|--------------|----------|------|
| Race bike painting bath | Mar CY-1 | £275k | 36 mo |
| Race bike assembly desks | Feb CY-2 | £670k | 48 mo |
| Road bike assembly desks | Feb CY-2 | £780k | 48 mo |
| MTB assembly desks | Feb CY-2 | £460k | 48 mo |
| Children's bike line | Oct CY | £905k | 36 mo |

#### Facility Status
- **Maywood House:** Corporate HQ - operational
- **Victoria House:** Unused, structurally sound, needs interior renovation (~£28k rewiring)
- **Facility B:** Operational
- **Maywood Warehouse:** Sold and leased back (£365k annual rent added)

#### IT Systems
- Current: Excel + SAGE (noted as weak)
- SAP implementation in progress (6 months negotiation on price)
- Focus areas: Accounting, data warehousing, plant management

#### Operational Concerns
1. Fork preparation equipment needs £50k repair in January
2. Environmental waste solution needed (~£75-100k) for tube sawing/soldering
3. Fixed asset register incomplete
4. Standard costs not regularly reviewed

---

### CMO (Joshua) - Marketing & Sales

#### Market Position
| Region | % Sales | Key Accounts |
|--------|---------|--------------|
| UK | 23% | Evans, Halfords, Cycle Surgery |
| Germany | 16% | Zweirad-Stadler (14%) |
| USA | 12% | REI (28% of US) |
| France | 8% | Intersport, Go-Sport |
| Benelux | 13% | Bike Totaal, Biretco |

#### Product Portfolio Analysis
| Category | Volume % | Price Range | Margin |
|----------|----------|-------------|--------|
| Race bikes | 8% | £1,500-3,400 | Highest |
| Road bikes | 33% | £400-1,200 | Good |
| Mountain bikes | 29% | £400-1,200 | Good |
| City bikes | 9% | £400 | Lower |
| Children's | 20% | £99-199 | Lowest |

#### Sales Team Dynamics
- **Hannah** (Head of Sales): £75k, 15 yrs exp, ex-Giant Bikes
- **Barry "Bas" West**: 32 yrs at Maywood, £30M sales (60% of volume), reports to Hannah
- **Tension exists** between Bas and Hannah - critical to manage

#### Key Marketing Concerns
1. Product modernization - cantilever brakes vs disc brakes
2. Online channel underdeveloped (only 5% through Wiggle/Chain Reactions)
3. Weak in Spain/Italy despite being large cycling markets
4. Customer feedback mechanisms unclear
5. Market research on new products (children's line, carbon fiber chain bike) unknown

#### Research Tasks (2x2 Matrices)
- [ ] Geography matrix - competitive positioning by region
- [ ] Product matrix - portfolio positioning analysis
- [ ] Segment matrix - customer segment analysis
- [ ] TAM definition and competitive landscape mapping

---

### CHRO (Liza) - Human Resources & Culture

#### Workforce Profile
- **Total employees:** 210 (down from 254 in CY-4)
- **Administrative staff:** 43 (monthly paid)
- **Production workers:** 167 (weekly paid)
- **Union:** Unite Union of TUC recognized for negotiations

#### Key Personnel Risks

| Name | Role | Risk Factor |
|------|------|-------------|
| Colleen Bryan | Head of Scheduling | Rumored to be considering job in Birmingham; "you can tell when she's not there" |
| Barry "Bas" West | Sales | 60% of sales volume; tension with boss |
| John Stephens | Plant Manager | 41 years at company; wants to bring manufacturing back |
| Tom Banks | IT | Only 2 years; critical for SAP implementation |

#### Employment Concerns
1. **No working time records** kept for salaried staff (Regulation 9 violation)
2. **No equal opportunity/race/disability policy** (though one planned for Employee Handbook)
3. **Pension deferral** - £120k deferred contributions to be made up over 3 years
4. **Redundancy terms** for Unite members require union negotiation

#### Staff Cost Sustainability
> "Staff costs for CY-1 and year to date are at 17% and 18% of turnover respectively... achieved as a result of staff cost controls including wage freezes and control of overtime payments. Such measures may not be sustainable in the longer term."

#### HR Concerns
1. Key person dependency (Colleen, Bas, John)
2. Wage freeze sustainability
3. Pension catch-up payments due
4. Union relations during transition
5. No formal HR policies documented

---

### CFO (Ali) - Finance & Treasury

#### Financial Snapshot (CY-1)

| Metric | Value |
|--------|-------|
| Revenue | £49.7M |
| Gross Margin | £16.9M (34%) |
| EBITDA | £2.4M |
| Net Profit | £376k |
| Net Equity | £23.2M |
| Total Assets | £42M |

#### Revenue Trend
- CY-4 to CY-1 decline: 4.0% → 3.3% → 1.2%
- Stabilizing but not growing

#### Debt Structure

| Facility | Amount | Lender | Terms |
|----------|--------|--------|-------|
| Mortgage | £5.8M | NatWest | Change of control trigger |
| Invoice Discounting | £5M limit | Barclays | 85% advance, 4% fee |
| Overdraft | £500k | Barclays | |
| Hire Purchase | ~£3M | Acme Amalgamated | 9% interest, 36-48 mo |

#### Working Capital Concerns
1. ~~Director loans (£1M) must be repaid at acquisition~~ - **PAID OFF IN SALE**
2. Seasonal cash flow strain (inventory build Q1)
3. Deferred pension contributions (~£350k shortfall)
4. PAYE payments historically deferred - compliance risk

#### Acquisition Financing
- Total investment: £10M
- Due diligence/legal costs: up to £360k from proceeds
- Seller's note guarantee: £10M (personally guaranteed by management)
- Closing target: 2 January

#### Financial Concerns
1. Limited documentation for 3-year forecasts
2. No monthly P&L/cash flow/balance sheets produced
3. SAGE system noted as weak
4. Deferred tax provision ~£350k short
5. Tax enquiry opened by Internal Revenue Medway

---

## III. Cross-Functional Risk Matrix

### TIER 1: EXISTENTIAL RISKS (Personal Liability Triggers)

| Risk | Impact | Likelihood | Owner | Mitigation |
|------|--------|------------|-------|------------|
| **20% Customer Loss** | **CATASTROPHIC** | Medium | ALL | Customer retention is #1 priority |
| **Loan Default** | **CATASTROPHIC** | Low | CFO/CEO | Cash flow management, lender relations |
| **PE Forced Redemption (Yr 6)** | **CRITICAL** | Medium | CEO | Hit targets, prepare exit options |

### TIER 2: HIGH-IMPACT BUSINESS RISKS

| Risk | Impact | Likelihood | Owner | Mitigation |
|------|--------|------------|-------|------------|
| Halfords credit demand/loss | High | High | CFO/CMO | Negotiate; they're ~2% of revenue |
| Zhongshan supply disruption | Critical | Medium | COO | Alternative frame suppliers |
| Miss PE growth targets | High | Medium | ALL | 10-15% CAGR strategy |
| Key person departure (Colleen) | High | Medium | CHRO | Retention package |
| Bas/Hannah conflict | High | High | CHRO/CMO | Mediation, clear reporting |
| NatWest loan called | Critical | Low | CFO | Proactive lender communication |

### TIER 3: OPERATIONAL RISKS

| Risk | Impact | Likelihood | Owner | Mitigation |
|------|--------|------------|-------|------------|
| Decathlon termination | Low | Certain | CMO | Already lost (~0.1% revenue) |
| Late delivery penalties | High | Medium | COO | Buffer stock, scheduling |
| Pension underfunding | Medium | Certain | CFO | Budget £350k catch-up |
| Union resistance | Medium | Medium | CHRO | Early engagement |
| Taiwan/US trade barrier | Medium | Certain | COO | Alternative routing for US orders |

---

## IV. Immediate Action Items (First 30 Days)

### PRIORITY ZERO: Protect Against 20% Customer Loss Default

**Current Revenue at Risk:**
- Decathlon: ~0.1% (LOST)
- Halfords: ~2% (demanding 150-day credit)
- Contracts expiring CY: Chain Reactions, Wiggle, Velo Vermeulen (BE)
- **Total potential loss if all CY contracts not renewed:** Need to calculate

**Action:** Map ALL customer revenue concentrations. Identify which combination of losses hits 20%.

---

### All C-Suite
- [ ] **URGENT:** Calculate customer concentration - which losses trigger 20%?
- [ ] Complete stakeholder mapping
- [ ] Establish communication cadence
- [ ] Align on 5-year strategy framework (10-15% CAGR target)
- [ ] Understand personal liability exposure

### CEO (Tommy)
- [ ] PE relationship - understand DratLink expectations in detail
- [ ] Lender relationship meetings (NatWest, HSBC, Barclays)
- [ ] Board meeting preparation (action plan due February)
- [ ] Wayne Fairfield (US distribution) - 51% owner of US JV
- [ ] E-bike strategy assessment (PE priority)

### COO (Jessica)
- [ ] Production capacity audit
- [ ] Supply chain risk assessment (Zhongshan alternatives)
- [ ] SAP implementation status review
- [ ] Victoria House potential (PE may want expansion)

### CMO (Joshua)
- [ ] **CRITICAL:** Customer retention outreach (ALL expiring contracts)
- [ ] Revenue concentration analysis (20% threshold)
- [ ] Bas/Hannah dynamics assessment
- [ ] Build 2x2 matrices (Geography, Product, Segment)
- [ ] E-bike market research (PE growth priority)

### CHRO (Liza)
- [ ] Key personnel retention conversations (Colleen, Bas, John)
- [ ] HR policy gap assessment
- [ ] Union leadership introduction
- [ ] Workforce well-being plan (PE ESG requirement)

### CFO (Ali)
- [ ] Cash flow forecast (90 days) - can we make June Year 1 payment?
- [ ] Facility limit stress test
- [ ] Tax enquiry status assessment
- [ ] LIBOR interest calculation - quarterly payment planning
- [ ] Model scenarios for PE redemption at Year 6

---

## V. Questions for Coach (Tori Fahey)

### Deal Structure
1. With personal guarantees and home equity at stake, what would you negotiate differently?
2. How do we manage the PE relationship to avoid Year 6 forced redemption?

### Operations & Growth
3. How did Apidura handle supplier concentration risk?
4. What's her view on disc brake transition timing?
5. **E-bikes:** Market entry strategy? Capital requirements? Margin profile?

### Brand & Marketing
6. How to balance Tour de France sponsorship cost vs brand value?
7. Her philosophy on "anti-impulse marketing" - applicable here?
8. Experience with UK cycling retail consolidation?

### Customer Retention (Critical)
9. Given the 20% customer loss default trigger, what's the playbook for retaining at-risk accounts?
10. How do we handle Halfords' 150-day credit demand without losing them?

---

## VI. Key Document Reference

| Document | Location | Key Content |
|----------|----------|-------------|
| Due Diligence Report | source_documents/01-Due-Diligence-nd.md | Financials, suppliers, retailers |
| Disclosure Letter | source_documents/Disclosure_Letter_2025.md | Red flags, warranties |
| Loan Note Instrument | source_documents/Loan_Note_Instrument.md | **Events of Default, Personal Liability** |
| Term Sheet | source_documents/Legally_Binding_Term_Sheet.md | Equity structure, guarantees |
| DratLink Investment Memo | source_documents/DratLink_Investment_Memo.md | PE expectations, targets |
| Sale & Purchase Agreement | source_documents/Sale_and_Purchase_Agreement.md | Full legal terms |
| Deed of Tax Covenant | source_documents/Deed_of_Tax_Covenant.md | Tax obligations |
| DD Lawyer Briefing | source_documents/DD_Lawyer_Briefing_nd.md | Negotiation points |

---

*Last updated: 15 December 2025*
